/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.modules.hibernate.business.SettableIdBasedEntity;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="wcm_menu_item")
@NotThreadSafe
public class WebCmsMenuItem
extends SettableIdBasedEntity<WebCmsMenuItem> {
    @Id
    @GeneratedValue(generator="seq_wcm_menu_item_id")
    @GenericGenerator(name="seq_wcm_menu_item_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_menu_item_id"), @Parameter(name="allocationSize", value="1")})
    private Long id;
    @NotNull
    @ManyToOne(optional=false)
    @JoinColumn(name="menu_id")
    private WebCmsMenu menu;
    @Column(name="menu_path")
    @NotBlank
    @Length(max=255)
    private @NotBlank @Length(max=255) String path;
    @Column
    @NotBlank
    @Length(max=255)
    private @NotBlank @Length(max=255) String title;
    @Column
    @Length(max=500)
    private @Length(max=500) String url;
    @ManyToOne
    @JoinColumn(name="endpoint_id")
    private WebCmsEndpoint endpoint;
    @Column(name="sort_index")
    private int sortIndex;
    @Column(name="is_group")
    private boolean group;
    @Column(name="is_generated")
    private boolean generated;

    public boolean hasEndpoint() {
        return this.getEndpoint() != null;
    }

    public static WebCmsMenuItemBuilder builder() {
        return new WebCmsMenuItemBuilder();
    }

    public WebCmsMenuItemBuilder toBuilder() {
        return new WebCmsMenuItemBuilder().id(this.id).menu(this.menu).path(this.path).title(this.title).url(this.url).endpoint(this.endpoint).sortIndex(this.sortIndex).group(this.group).generated(this.generated);
    }

    public WebCmsMenuItem() {
    }

    private WebCmsMenuItem(Long id, WebCmsMenu menu, String path, String title, String url, WebCmsEndpoint endpoint, int sortIndex, boolean group, boolean generated) {
        this.id = id;
        this.menu = menu;
        this.path = path;
        this.title = title;
        this.url = url;
        this.endpoint = endpoint;
        this.sortIndex = sortIndex;
        this.group = group;
        this.generated = generated;
    }

    public Long getId() {
        return this.id;
    }

    public WebCmsMenu getMenu() {
        return this.menu;
    }

    public String getPath() {
        return this.path;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public WebCmsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public boolean isGroup() {
        return this.group;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMenu(WebCmsMenu menu) {
        this.menu = menu;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setEndpoint(WebCmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setGroup(boolean group) {
        this.group = group;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public static class WebCmsMenuItemBuilder {
        private Long id;
        private WebCmsMenu menu;
        private String path;
        private String title;
        private String url;
        private WebCmsEndpoint endpoint;
        private int sortIndex;
        private boolean group;
        private boolean generated;

        WebCmsMenuItemBuilder() {
        }

        public WebCmsMenuItemBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsMenuItemBuilder menu(WebCmsMenu menu) {
            this.menu = menu;
            return this;
        }

        public WebCmsMenuItemBuilder path(String path) {
            this.path = path;
            return this;
        }

        public WebCmsMenuItemBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WebCmsMenuItemBuilder url(String url) {
            this.url = url;
            return this;
        }

        public WebCmsMenuItemBuilder endpoint(WebCmsEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public WebCmsMenuItemBuilder sortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public WebCmsMenuItemBuilder group(boolean group) {
            this.group = group;
            return this;
        }

        public WebCmsMenuItemBuilder generated(boolean generated) {
            this.generated = generated;
            return this;
        }

        public WebCmsMenuItem build() {
            return new WebCmsMenuItem(this.id, this.menu, this.path, this.title, this.url, this.endpoint, this.sortIndex, this.group, this.generated);
        }

        public String toString() {
            return "WebCmsMenuItem.WebCmsMenuItemBuilder(id=" + this.id + ", menu=" + this.menu + ", path=" + this.path + ", title=" + this.title + ", url=" + this.url + ", endpoint=" + this.endpoint + ", sortIndex=" + this.sortIndex + ", group=" + this.group + ", generated=" + this.generated + ")";
        }
    }
}

