/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.modules.webcms.data.AbstractWebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItemRepository;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebCmsMenuItemImporter
extends AbstractWebCmsPropertyDataImporter<WebCmsMenu, WebCmsMenuItem> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsMenuItemImporter.class);
    static final String PROPERTY_NAME = "items";
    private final WebCmsMenuItemRepository webCmsMenuItemRepository;
    private final WebCmsAssetEndpointRepository webCmsAssetEndpointRepository;
    private final WebCmsDataConversionService webCmsDataConversionService;
    private final WebCmsMultiDomainService multiDomainService;

    @Override
    public boolean supports(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return WebCmsPropertyDataImporter.Phase.AFTER_ASSET_SAVED.equals((Object)phase) && PROPERTY_NAME.equals(dataEntry.getParentKey()) && asset instanceof WebCmsMenu;
    }

    @Override
    protected WebCmsMenuItem createDto(WebCmsDataEntry menuDataSet, WebCmsMenuItem existing, WebCmsDataAction action, WebCmsMenu parent) {
        if (existing != null) {
            if (action == WebCmsDataAction.REPLACE) {
                WebCmsMenuItem menuItem = this.createNewMenuItemDto(menuDataSet, parent);
                menuItem.setId(existing.getId());
                return menuItem;
            }
            return (WebCmsMenuItem)existing.toDto();
        }
        return this.createNewMenuItemDto(menuDataSet, parent);
    }

    @Override
    protected boolean applyDataValues(Map<String, Object> values, WebCmsMenuItem dto) {
        HashMap<String, Object> filtered = new HashMap<String, Object>(values);
        this.attachAsset(filtered, dto);
        return super.applyDataValues(filtered, dto);
    }

    private WebCmsMenuItem createNewMenuItemDto(WebCmsDataEntry data, WebCmsMenu parent) {
        String key = data.getMapData().containsKey("path") ? (String)data.getMapData().get("path") : data.getKey();
        return WebCmsMenuItem.builder().menu(parent).path(key).build();
    }

    private void attachAsset(Map<String, Object> data, WebCmsMenuItem dto) {
        WebCmsUrl primaryUrl;
        WebCmsEndpoint endpoint;
        WebCmsAsset asset;
        String assetKey = (String)data.getOrDefault("asset", "");
        if (StringUtils.isNotEmpty((CharSequence)assetKey) && (asset = (WebCmsAsset)this.webCmsDataConversionService.convert(assetKey, WebCmsAsset.class)) != null && (endpoint = (WebCmsEndpoint)this.webCmsAssetEndpointRepository.findOneByAssetAndDomain(asset, this.multiDomainService.getCurrentDomainForEntity(asset)).orElse(null)) != null && (primaryUrl = (WebCmsUrl)endpoint.getPrimaryUrl().orElse(null)) != null) {
            boolean generated = !data.containsKey("title") && !data.containsKey("path");
            dto.setEndpoint(endpoint);
            dto.setGenerated(generated);
            if (dto.isNew() && StringUtils.isEmpty((CharSequence)dto.getPath())) {
                dto.setPath(primaryUrl.getPath());
            }
            dto.setTitle(asset.getName());
        }
        data.remove("asset");
    }

    @Override
    protected void save(WebCmsMenuItem dto, WebCmsMenu parent) {
        this.webCmsMenuItemRepository.save((Object)dto);
    }

    @Override
    protected void delete(WebCmsMenuItem dto, WebCmsMenu parent) {
        this.webCmsMenuItemRepository.delete((Object)dto);
    }

    @Override
    protected WebCmsMenuItem getExisting(WebCmsDataEntry dataKey, WebCmsMenu parent) {
        String key = dataKey.getMapData().containsKey("path") ? (String)dataKey.getMapData().get("path") : dataKey.getKey();
        return this.webCmsMenuItemRepository.findByMenuAndPath(parent, key).orElse(null);
    }

    public WebCmsMenuItemImporter(WebCmsMenuItemRepository webCmsMenuItemRepository, WebCmsAssetEndpointRepository webCmsAssetEndpointRepository, WebCmsDataConversionService webCmsDataConversionService, WebCmsMultiDomainService multiDomainService) {
        this.webCmsMenuItemRepository = webCmsMenuItemRepository;
        this.webCmsAssetEndpointRepository = webCmsAssetEndpointRepository;
        this.webCmsDataConversionService = webCmsDataConversionService;
        this.multiDomainService = multiDomainService;
    }
}

