/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.modules.webcms.data.AbstractWebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.StringToWebCmsDomainConverter;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItemRepository;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuRepository;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebCmsMenuItemOnAssetImporter
extends AbstractWebCmsPropertyDataImporter<WebCmsAsset, WebCmsMenuItem> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsMenuItemOnAssetImporter.class);
    private static final String PROPERTY_NAME = "wcm:menu-items";
    private final WebCmsMenuRepository menuRepository;
    private final WebCmsMenuItemRepository menuItemRepository;
    private final WebCmsAssetEndpointRepository assetEndpointRepository;
    private final WebCmsMultiDomainService multiDomainService;
    private final StringToWebCmsDomainConverter domainConverter;

    @Override
    public boolean supports(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return WebCmsPropertyDataImporter.Phase.AFTER_ASSET_SAVED.equals((Object)phase) && PROPERTY_NAME.equals(dataEntry.getParentKey()) && asset instanceof WebCmsAsset;
    }

    @Override
    protected WebCmsMenuItem createDto(WebCmsDataEntry menuDataSet, WebCmsMenuItem existing, WebCmsDataAction action, WebCmsAsset asset) {
        if (existing != null) {
            if (action == WebCmsDataAction.REPLACE) {
                WebCmsMenuItem menuItem = this.createNewMenuItemDto(menuDataSet, asset, existing.getEndpoint());
                if (menuItem != null) {
                    menuItem.setId(existing.getId());
                }
                return menuItem;
            }
            return (WebCmsMenuItem)existing.toDto();
        }
        return this.createNewMenuItemDto(menuDataSet, asset, null);
    }

    private WebCmsMenuItem createNewMenuItemDto(WebCmsDataEntry data, WebCmsAsset asset, WebCmsEndpoint endpointToUse) {
        WebCmsEndpoint endpoint;
        WebCmsEndpoint webCmsEndpoint = endpoint = endpointToUse != null ? endpointToUse : (WebCmsEndpoint)this.assetEndpointRepository.findOneByAssetAndDomain(asset, asset.getDomain()).orElse(null);
        if (endpoint != null) {
            WebCmsMenu menu = this.retrieveMenu(data, asset.getDomain());
            WebCmsUrl primaryUrl = endpoint.getPrimaryUrl().orElse(null);
            if (primaryUrl != null) {
                boolean generated = !data.getMapData().containsKey("title") && !data.getMapData().containsKey("path");
                return WebCmsMenuItem.builder().menu(menu).endpoint(endpoint).path(primaryUrl.getPath()).title(asset.getName()).generated(generated).build();
            }
        }
        LOG.warn("Unable to create menu item as no endpoint available for asset {} - data: {}", (Object)asset.getObjectId(), (Object)data);
        return null;
    }

    @Override
    protected void save(WebCmsMenuItem dto, WebCmsAsset parent) {
        this.menuItemRepository.save((Object)dto);
    }

    @Override
    protected void delete(WebCmsMenuItem dto, WebCmsAsset parent) {
        this.menuItemRepository.delete((Object)dto);
    }

    @Override
    protected boolean applyDataValues(Map<String, Object> values, WebCmsMenuItem dto) {
        HashMap<String, Object> filtered = new HashMap<String, Object>(values);
        filtered.remove("menu");
        filtered.remove("domain");
        return super.applyDataValues(filtered, dto);
    }

    @Override
    protected WebCmsMenuItem getExisting(WebCmsDataEntry data, WebCmsAsset parent) {
        WebCmsAssetEndpoint endpoint = this.assetEndpointRepository.findOneByAssetAndDomain(parent, this.multiDomainService.getCurrentDomainForEntity(parent)).orElse(null);
        if (endpoint != null) {
            WebCmsMenu menu = this.retrieveMenu(data, parent.getDomain());
            return this.menuItemRepository.findAllByEndpoint(endpoint).stream().filter(item -> item.getMenu().equals(menu)).findFirst().orElse(null);
        }
        return null;
    }

    private WebCmsMenu retrieveMenu(WebCmsDataEntry data, WebCmsDomain domain) {
        WebCmsDomain dataDomain = data.getMapData().containsKey("domain") ? this.domainConverter.convert((String)data.getMapData().get("domain")) : domain;
        return this.menuRepository.findOneByNameAndDomain(StringUtils.defaultString((String)((String)data.getMapData().get("menu")), (String)data.getKey()), dataDomain).orElse(null);
    }

    public WebCmsMenuItemOnAssetImporter(WebCmsMenuRepository menuRepository, WebCmsMenuItemRepository menuItemRepository, WebCmsAssetEndpointRepository assetEndpointRepository, WebCmsMultiDomainService multiDomainService, StringToWebCmsDomainConverter domainConverter) {
        this.menuRepository = menuRepository;
        this.menuItemRepository = menuItemRepository;
        this.assetEndpointRepository = assetEndpointRepository;
        this.multiDomainService = multiDomainService;
        this.domainConverter = domainConverter;
    }
}

