/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuRepository;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuService;
import org.springframework.stereotype.Service;

@Service
class WebCmsMenuServiceImpl
implements WebCmsMenuService {
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsMenuRepository menuRepository;

    @Override
    public WebCmsMenu getMenuByName(String menuName) {
        return this.getMenuByName(menuName, this.multiDomainService.getCurrentDomainForType(WebCmsMenu.class));
    }

    @Override
    public WebCmsMenu getMenuByName(String menuName, WebCmsDomain domain) {
        WebCmsMenu menu = this.menuRepository.findOneByNameAndDomain(menuName, domain).orElse(null);
        if (menu == null && !WebCmsDomain.isNoDomain(domain) && this.multiDomainService.isNoDomainAllowed(WebCmsMenu.class)) {
            menu = this.menuRepository.findOneByNameAndDomain(menuName, WebCmsDomain.NONE).orElse(null);
        }
        return menu;
    }

    public WebCmsMenuServiceImpl(WebCmsMultiDomainService multiDomainService, WebCmsMenuRepository menuRepository) {
        this.multiDomainService = multiDomainService;
        this.menuRepository = menuRepository;
    }
}

