/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu.config;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntityConfigurationBuilder;
import com.foreach.across.modules.entity.query.AssociatedEntityQueryExecutor;
import com.foreach.across.modules.entity.query.EntityQueryCondition;
import com.foreach.across.modules.entity.query.EntityQueryExecutor;
import com.foreach.across.modules.entity.query.EntityQueryOps;
import com.foreach.across.modules.entity.registry.EntityAssociation;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityFactory;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.asset.QWebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainAdminUiService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.querydsl.core.types.Predicate;
import java.util.HashSet;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Sort;

@ConditionalOnAdminUI
@Exposed
@Configuration
public class WebCmsAssetMenuViewsConfiguration {
    private final Set<Class<?>> assetTypes = new HashSet();
    private final EntityRegistry entityRegistry;
    private final WebCmsAssetEndpointRepository assetEndpointRepository;
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsMultiDomainAdminUiService multiDomainAdminUiService;

    public void enable(Class<? extends WebCmsAsset> assetType) {
        this.assetTypes.add(assetType);
    }

    public void disable(Class<? extends WebCmsAsset> assetType) {
        this.assetTypes.remove(assetType);
    }

    public void registerMenuItemsAssociation(EntityConfigurationBuilder<?> configuration) {
        configuration.association(ab -> ab.name("webCmsMenuItems").targetEntityType(WebCmsMenuItem.class).targetProperty("endpoint").associationType(EntityAssociation.Type.EMBEDDED).parentDeleteMode(EntityAssociation.ParentDeleteMode.WARN).listView(fvb -> fvb.showProperties(new String[]{".", "~endpoint"}).defaultSort(Sort.by((String[])new String[]{"menu", "path"}))).createFormView(fvb -> fvb.showProperties(new String[]{".", "~endpoint"})).updateFormView(fvb -> fvb.showProperties(new String[]{".", "~endpoint"})).deleteFormView().attribute(EntityFactory.class, this.createWebCmsMenuItemEntityFactory()).show()).postProcessor(cfg -> cfg.association("webCmsMenuItems").setAttribute(AssociatedEntityQueryExecutor.class, this.createExecutorForWebCmsMenuItem()));
    }

    private AssociatedEntityQueryExecutor<WebCmsMenuItem> createExecutorForWebCmsMenuItem() {
        EntityConfiguration entityConfiguration = this.entityRegistry.getEntityConfiguration(WebCmsMenuItem.class);
        EntityQueryExecutor entityQueryExecutor = (EntityQueryExecutor)entityConfiguration.getAttribute(EntityQueryExecutor.class);
        return new AssociatedEntityQueryExecutor<WebCmsMenuItem>(null, entityQueryExecutor){

            protected EntityQueryCondition buildEqualsOrContainsCondition(Object value) {
                QWebCmsAssetEndpoint query = QWebCmsAssetEndpoint.webCmsAssetEndpoint;
                Iterable endpoint = WebCmsAssetMenuViewsConfiguration.this.assetEndpointRepository.findAll(WebCmsAssetMenuViewsConfiguration.this.multiDomainAdminUiService.applyVisibleDomainsPredicate((Predicate)query.asset.eq((WebCmsAsset)value), query.domain));
                return new EntityQueryCondition("endpoint", EntityQueryOps.IN, endpoint.toArray());
            }
        };
    }

    private EntityFactory<WebCmsMenuItem> createWebCmsMenuItemEntityFactory() {
        return new EntityFactory<WebCmsMenuItem>(){

            public WebCmsMenuItem createNew(Object ... args) {
                WebCmsMenuItem item = new WebCmsMenuItem();
                if (args[0] instanceof WebCmsAsset) {
                    WebCmsAsset asset = (WebCmsAsset)args[0];
                    item.setEndpoint(WebCmsAssetMenuViewsConfiguration.this.assetEndpointRepository.findOneByAssetAndDomain(asset, WebCmsAssetMenuViewsConfiguration.this.multiDomainService.getCurrentDomainForEntity(asset)).orElse(null));
                }
                return item;
            }

            public WebCmsMenuItem createDto(WebCmsMenuItem entity) {
                return (WebCmsMenuItem)entity.toDto();
            }
        };
    }

    @Bean
    EntityConfigurer webCmsMenuItemsAssociationConfigurer() {
        return entities -> this.registerMenuItemsAssociation(entities.matching(config -> WebCmsAsset.class.isAssignableFrom(config.getEntityType()) && this.assetTypes.contains(config.getEntityType())));
    }

    public WebCmsAssetMenuViewsConfiguration(EntityRegistry entityRegistry, WebCmsAssetEndpointRepository assetEndpointRepository, WebCmsMultiDomainService multiDomainService, WebCmsMultiDomainAdminUiService multiDomainAdminUiService) {
        this.entityRegistry = entityRegistry;
        this.assetEndpointRepository = assetEndpointRepository;
        this.multiDomainService = multiDomainService;
        this.multiDomainAdminUiService = multiDomainAdminUiService;
    }
}

