/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.menu.validators;

import com.foreach.across.modules.entity.validators.EntityValidatorSupport;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuRepository;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class WebCmsMenuValidator
extends EntityValidatorSupport<WebCmsMenu> {
    private final WebCmsMenuRepository menuRepository;

    public boolean supports(Class<?> clazz) {
        return WebCmsMenu.class.isAssignableFrom(clazz);
    }

    protected void postValidation(WebCmsMenu entity, Errors errors, Object ... validationHints) {
        if (!errors.hasFieldErrors("name")) {
            this.menuRepository.findOneByNameAndDomain(entity.getName(), entity.getDomain()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("name", "alreadyExists"));
        }
        if (!errors.hasFieldErrors("name") && !errors.hasFieldErrors("objectId")) {
            this.menuRepository.findOneByObjectId(entity.getObjectId()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("objectId", "alreadyExists"));
        }
    }

    public WebCmsMenuValidator(WebCmsMenuRepository menuRepository) {
        this.menuRepository = menuRepository;
    }
}

