/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.repositories.WebCmsPageRepository;
import com.foreach.across.modules.webcms.domain.page.services.WebCmsPageService;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public final class StringToWebCmsPageConverter
implements Converter<String, WebCmsPage> {
    private final WebCmsPageRepository pageRepository;
    private final WebCmsPageService pageService;

    @Autowired
    void register(WebCmsDataConversionService conversionService) {
        conversionService.addConverter(this);
    }

    public WebCmsPage convert(String source) {
        if (NumberUtils.isDigits((String)source)) {
            return this.pageRepository.findById(Long.parseLong(source)).orElse(null);
        }
        if (source.startsWith("/")) {
            return this.pageService.findByCanonicalPath(source).orElse(null);
        }
        return this.pageRepository.findOneByObjectId(source).orElse(null);
    }

    public StringToWebCmsPageConverter(WebCmsPageRepository pageRepository, WebCmsPageService pageService) {
        this.pageRepository = pageRepository;
        this.pageService = pageService;
    }
}

