/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.page.WebCmsPageType;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

@Entity
@DiscriminatorValue(value="page")
@Table(name="wcm_page")
@NotThreadSafe
public class WebCmsPage
extends WebCmsAsset<WebCmsPage> {
    public static final String OBJECT_TYPE = "page";
    public static final String COLLECTION_ID = "wcm:asset:page";
    @Column
    @NotBlank
    @Length(max=255)
    private @NotBlank @Length(max=255) String title;
    @ManyToOne
    @JoinColumn(name="parent_id")
    private WebCmsPage parent;
    @Column(name="path_segment")
    @NotNull
    @Length(max=255)
    private @NotNull @Length(max=255) String pathSegment;
    @Column(name="path_segment_generated")
    private boolean pathSegmentGenerated = true;
    @Column(name="canonical_path")
    @NotNull
    @Length(max=500)
    private @NotNull @Length(max=500) String canonicalPath;
    @Column(name="canonical_path_generated")
    private boolean canonicalPathGenerated = true;
    @Column
    @Length(max=255)
    private @Length(max=255) String template;
    @ManyToOne
    @JoinColumn(name="page_type_id")
    @NotNull
    private WebCmsPageType pageType;

    protected WebCmsPage(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain, boolean published, Date publicationDate, int sortIndex, String title, WebCmsPage parent, String pathSegment, boolean pathSegmentGenerated, String canonicalPath, boolean canonicalPathGenerated, String template, WebCmsPageType pageType) {
        super(id, newEntityId, objectId, createdBy, createdDate, lastModifiedBy, lastModifiedDate, domain, published, publicationDate, sortIndex);
        this.title = title;
        this.parent = parent;
        this.pathSegment = pathSegment;
        this.pathSegmentGenerated = pathSegmentGenerated;
        this.canonicalPath = canonicalPath;
        this.canonicalPathGenerated = canonicalPathGenerated;
        this.template = template;
        this.pageType = pageType;
    }

    @Override
    public final String getObjectType() {
        return OBJECT_TYPE;
    }

    @Override
    protected final String getObjectCollectionId() {
        return COLLECTION_ID;
    }

    @Override
    public final String getName() {
        return this.getTitle();
    }

    @Override
    public String toString() {
        return "WebCmsPage{objectId='" + this.getObjectId() + "',canonicalPath='" + this.canonicalPath + '\'' + '}';
    }

    @Override
    public WebCmsPageType getAssetType() {
        return this.pageType;
    }

    public static WebCmsPageBuilder builder() {
        return new WebCmsPageBuilder();
    }

    public WebCmsPageBuilder toBuilder() {
        Long id = this.getId();
        Long newEntityId = this.getNewEntityId();
        String objectId = this.getObjectId();
        String createdBy = this.getCreatedBy();
        Date createdDate = this.getCreatedDate();
        String lastModifiedBy = this.getLastModifiedBy();
        Date lastModifiedDate = this.getLastModifiedDate();
        WebCmsDomain domain = this.getDomain();
        boolean published = this.isPublished();
        Date publicationDate = this.getPublicationDate();
        int sortIndex = this.getSortIndex();
        return new WebCmsPageBuilder().id(id).newEntityId(newEntityId).objectId(objectId).createdBy(createdBy).createdDate(createdDate).lastModifiedBy(lastModifiedBy).lastModifiedDate(lastModifiedDate).domain(domain).published(published).publicationDate(publicationDate).sortIndex(sortIndex).title(this.title).parent(this.parent).pathSegment(this.pathSegment).pathSegmentGenerated(this.pathSegmentGenerated).canonicalPath(this.canonicalPath).canonicalPathGenerated(this.canonicalPathGenerated).template(this.template).pageType(this.pageType);
    }

    public WebCmsPage() {
    }

    public String getTitle() {
        return this.title;
    }

    public WebCmsPage getParent() {
        return this.parent;
    }

    public String getPathSegment() {
        return this.pathSegment;
    }

    public boolean isPathSegmentGenerated() {
        return this.pathSegmentGenerated;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public boolean isCanonicalPathGenerated() {
        return this.canonicalPathGenerated;
    }

    public String getTemplate() {
        return this.template;
    }

    public WebCmsPageType getPageType() {
        return this.pageType;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setParent(WebCmsPage parent) {
        this.parent = parent;
    }

    public void setPathSegment(String pathSegment) {
        this.pathSegment = pathSegment;
    }

    public void setPathSegmentGenerated(boolean pathSegmentGenerated) {
        this.pathSegmentGenerated = pathSegmentGenerated;
    }

    public void setCanonicalPath(String canonicalPath) {
        this.canonicalPath = canonicalPath;
    }

    public void setCanonicalPathGenerated(boolean canonicalPathGenerated) {
        this.canonicalPathGenerated = canonicalPathGenerated;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setPageType(WebCmsPageType pageType) {
        this.pageType = pageType;
    }

    public static class WebCmsPageBuilder {
        private Long id;
        private Long newEntityId;
        private String objectId;
        private String createdBy;
        private Date createdDate;
        private String lastModifiedBy;
        private Date lastModifiedDate;
        private WebCmsDomain domain;
        private boolean published;
        private Date publicationDate;
        private String title;
        private WebCmsPage parent;
        private String pathSegment;
        private String canonicalPath;
        private String template;
        private WebCmsPageType pageType;
        private boolean pathSegmentGenerated = true;
        private boolean canonicalPathGenerated = true;
        private int sortIndex = 1000;

        WebCmsPageBuilder() {
        }

        public WebCmsPageBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsPageBuilder newEntityId(Long newEntityId) {
            this.newEntityId = newEntityId;
            return this;
        }

        public WebCmsPageBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public WebCmsPageBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public WebCmsPageBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public WebCmsPageBuilder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public WebCmsPageBuilder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public WebCmsPageBuilder domain(WebCmsDomain domain) {
            this.domain = domain;
            return this;
        }

        public WebCmsPageBuilder published(boolean published) {
            this.published = published;
            return this;
        }

        public WebCmsPageBuilder publicationDate(Date publicationDate) {
            this.publicationDate = publicationDate;
            return this;
        }

        public WebCmsPageBuilder sortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public WebCmsPageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public WebCmsPageBuilder parent(WebCmsPage parent) {
            this.parent = parent;
            return this;
        }

        public WebCmsPageBuilder pathSegment(String pathSegment) {
            this.pathSegment = pathSegment;
            return this;
        }

        public WebCmsPageBuilder pathSegmentGenerated(boolean pathSegmentGenerated) {
            this.pathSegmentGenerated = pathSegmentGenerated;
            return this;
        }

        public WebCmsPageBuilder canonicalPath(String canonicalPath) {
            this.canonicalPath = canonicalPath;
            return this;
        }

        public WebCmsPageBuilder canonicalPathGenerated(boolean canonicalPathGenerated) {
            this.canonicalPathGenerated = canonicalPathGenerated;
            return this;
        }

        public WebCmsPageBuilder template(String template) {
            this.template = template;
            return this;
        }

        public WebCmsPageBuilder pageType(WebCmsPageType pageType) {
            this.pageType = pageType;
            return this;
        }

        public WebCmsPage build() {
            return new WebCmsPage(this.id, this.newEntityId, this.objectId, this.createdBy, this.createdDate, this.lastModifiedBy, this.lastModifiedDate, this.domain, this.published, this.publicationDate, this.sortIndex, this.title, this.parent, this.pathSegment, this.pathSegmentGenerated, this.canonicalPath, this.canonicalPathGenerated, this.template, this.pageType);
        }

        public String toString() {
            return "WebCmsPage.WebCmsPageBuilder(id=" + this.id + ", newEntityId=" + this.newEntityId + ", objectId=" + this.objectId + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy=" + this.lastModifiedBy + ", lastModifiedDate=" + this.lastModifiedDate + ", domain=" + this.domain + ", published=" + this.published + ", publicationDate=" + this.publicationDate + ", sortIndex=" + this.sortIndex + ", title=" + this.title + ", parent=" + this.parent + ", pathSegment=" + this.pathSegment + ", pathSegmentGenerated=" + this.pathSegmentGenerated + ", canonicalPath=" + this.canonicalPath + ", canonicalPathGenerated=" + this.canonicalPathGenerated + ", template=" + this.template + ", pageType=" + this.pageType + ")";
        }
    }
}

