/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page;

import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.asset.AbstractWebCmsAssetImporter;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.services.WebCmsPageService;
import com.foreach.across.modules.webcms.domain.page.validators.WebCmsPageValidator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public final class WebCmsPageImporter
extends AbstractWebCmsAssetImporter<WebCmsPage> {
    private WebCmsPageValidator pageValidator;
    private WebCmsPageService pageService;

    public WebCmsPageImporter() {
        super("page", WebCmsPage.class);
    }

    @Override
    protected WebCmsPage createDto(WebCmsDataEntry data, WebCmsPage itemToUpdate, WebCmsDataAction action, Map<String, Object> dataValues) {
        WebCmsPage dto;
        if (action == WebCmsDataAction.REPLACE) {
            dto = this.createDefaultPageDto(data);
            dto.setObjectId(itemToUpdate.getObjectId());
            dto.setId(itemToUpdate.getId());
            dto.setCreatedBy(itemToUpdate.getCreatedBy());
            dto.setCreatedDate(itemToUpdate.getCreatedDate());
        } else {
            dto = itemToUpdate != null ? (WebCmsPage)itemToUpdate.toDto() : this.createDefaultPageDto(data);
        }
        Map<String, Object> properties = data.getMapData();
        if (properties.containsKey("pathSegment")) {
            dto.setPathSegmentGenerated(false);
        }
        if (properties.containsKey("canonicalPath")) {
            dto.setCanonicalPathGenerated(false);
        }
        return dto;
    }

    private WebCmsPage createDefaultPageDto(WebCmsDataEntry data) {
        WebCmsPage page = new WebCmsPage();
        String canonicalPath = data.getKey();
        if (canonicalPath != null) {
            page.setCanonicalPath(canonicalPath);
            page.setCanonicalPathGenerated(false);
        }
        return page;
    }

    @Override
    protected WebCmsPage prepareForSaving(WebCmsPage itemToBeSaved, WebCmsDataEntry data) {
        this.pageService.prepareForSaving(itemToBeSaved);
        return itemToBeSaved;
    }

    @Override
    protected WebCmsPage getExistingEntity(String entryKey, WebCmsDataEntry data, WebCmsDomain domain) {
        if (StringUtils.isEmpty((CharSequence)entryKey)) {
            if (!data.getMapData().containsKey("canonicalPath")) {
                return null;
            }
            entryKey = (String)data.getMapData().get("canonicalPath");
        }
        return this.pageService.findByCanonicalPathAndDomain(entryKey, domain).orElse(null);
    }

    @Override
    protected void validate(WebCmsPage itemToBeSaved, Errors errors) {
        this.pageValidator.validate(itemToBeSaved, errors);
    }

    @Autowired
    void setPageService(WebCmsPageService pageService) {
        this.pageService = pageService;
    }

    @Autowired
    void setPageValidator(WebCmsPageValidator pageValidator) {
        this.pageValidator = pageValidator;
    }
}

