/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.type.WebCmsDefaultComponentsService;
import java.util.HashMap;
import org.springframework.stereotype.Component;

@Component
public class WebCmsPageInterceptor
extends EntityInterceptorAdapter<WebCmsPage> {
    private final WebCmsEndpointService endpointService;
    private final WebCmsDefaultComponentsService webCmsTypeComponentsStrategy;

    public boolean handles(Class<?> entityClass) {
        return WebCmsPage.class.isAssignableFrom(entityClass);
    }

    public void afterCreate(WebCmsPage entity) {
        this.createDefaultComponents(entity);
        this.endpointService.updateOrCreatePrimaryUrlForAsset(entity.getCanonicalPath(), entity, true);
    }

    private void createDefaultComponents(WebCmsPage entity) {
        HashMap<String, String> markerValues = new HashMap<String, String>();
        markerValues.put("@@title@@", entity.getTitle());
        this.webCmsTypeComponentsStrategy.createDefaultComponents(entity, markerValues);
    }

    public void afterUpdate(WebCmsPage entity) {
        this.endpointService.updateOrCreatePrimaryUrlForAsset(entity.getCanonicalPath(), entity, true);
    }

    public WebCmsPageInterceptor(WebCmsEndpointService endpointService, WebCmsDefaultComponentsService webCmsTypeComponentsStrategy) {
        this.endpointService = endpointService;
        this.webCmsTypeComponentsStrategy = webCmsTypeComponentsStrategy;
    }
}

