/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.config;

import com.foreach.across.modules.bootstrapui.elements.TableViewElement;
import com.foreach.across.modules.bootstrapui.elements.TextboxFormElement;
import com.foreach.across.modules.bootstrapui.elements.builder.ButtonViewElementBuilder;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.registry.properties.EntityPropertySelector;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.ViewElementMode;
import com.foreach.across.modules.entity.views.bootstrapui.util.SortableTableBuilder;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.processors.support.ViewElementBuilderMap;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.views.support.EntityMessages;
import com.foreach.across.modules.entity.views.util.EntityViewElementUtils;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.WebCmsModuleIcons;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetService;
import com.foreach.across.modules.webcms.domain.asset.web.processors.WebCmsAssetListViewProcessor;
import com.foreach.across.modules.webcms.domain.component.config.WebCmsObjectComponentViewsConfiguration;
import com.foreach.across.modules.webcms.domain.component.web.SearchComponentViewProcessor;
import com.foreach.across.modules.webcms.domain.menu.config.WebCmsAssetMenuViewsConfiguration;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.WebCmsPageType;
import com.foreach.across.modules.webcms.domain.page.web.MenuItemsViewElementBuilder;
import com.foreach.across.modules.webcms.domain.page.web.PageFormViewProcessor;
import com.foreach.across.modules.webcms.domain.redirect.WebCmsRemoteEndpoint;
import com.foreach.across.modules.webcms.domain.url.config.WebCmsAssetUrlConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebCmsPageConfiguration {
    public static final String PATH_SEGMENT = "pathSegment";
    public static final String CANONICAL_PATH = "canonicalPath";
    private static final String PAGE_TYPE = "pageType";
    private static final String PUBLISH_SETTINGS = "publish-settings";

    @Autowired
    void enableUrls(WebCmsAssetUrlConfiguration urlConfiguration) {
        urlConfiguration.enable(WebCmsPage.class);
    }

    private static class PageListViewProcessor
    extends EntityViewProcessorAdapter {
        private WebCmsAssetService assetPreviewService;

        private PageListViewProcessor() {
        }

        protected void createViewElementBuilders(EntityViewRequest entityViewRequest, EntityView entityView, ViewElementBuilderMap builderMap) {
            if (builderMap.containsKey((Object)"sortableTableBuilder")) {
                ((SortableTableBuilder)builderMap.get("sortableTableBuilder", SortableTableBuilder.class)).valueRowProcessor((ctx, row) -> {
                    WebCmsPage page = (WebCmsPage)EntityViewElementUtils.currentEntity((ViewElementBuilderContext)ctx, WebCmsPage.class);
                    ContainerViewElementUtils.find((ContainerViewElement)row, (String)"row-actions", TableViewElement.Cell.class).ifPresent(cell -> this.assetPreviewService.buildPreviewUrl(page).ifPresent(previewUrl -> {
                        EntityMessages entityMessages = entityViewRequest.getEntityViewContext().getEntityMessages();
                        cell.addFirstChild((ViewElement)((ButtonViewElementBuilder)BootstrapViewElements.bootstrap.builders.button().link(previewUrl).attribute("target", (Object)"_blank")).iconOnly((ViewElement)WebCmsModuleIcons.webCmsIcons.preview()).text(entityMessages.withNameSingular("actions.open", new Object[0])).build(ctx));
                    }));
                });
            }
        }

        @Autowired
        public void setAssetPreviewService(WebCmsAssetService assetPreviewService) {
            this.assetPreviewService = assetPreviewService;
        }
    }

    @ConditionalOnAdminUI
    @Configuration
    static class PageAdminUi
    implements EntityConfigurer {
        private final PageFormViewProcessor pageFormViewProcessor;
        private final MenuItemsViewElementBuilder menuItemsViewElementBuilder;

        @Autowired
        void enableComponents(WebCmsObjectComponentViewsConfiguration componentViewsConfiguration) {
            componentViewsConfiguration.enable(WebCmsPage.class);
        }

        @Autowired
        void enableMenuItems(WebCmsAssetMenuViewsConfiguration menuViewsConfiguration) {
            menuViewsConfiguration.enable(WebCmsPage.class);
        }

        public void configure(EntitiesConfigurationBuilder entities) {
            entities.withType(WebCmsRemoteEndpoint.class).association(ab -> ab.name("webCmsRemoteEndpoint.urls").show());
            entities.withType(WebCmsPageType.class).association(ab -> ab.name("webCmsPage.pageType").listView(lvb -> lvb.showProperties(new String[]{WebCmsPageConfiguration.CANONICAL_PATH, "title", "parent"}).viewProcessor((EntityViewProcessor)new WebCmsAssetListViewProcessor())));
            entities.withType(WebCmsPage.class).attribute(SearchComponentViewProcessor.COMPONENT_SEARCH_QUERY, (Object)"title like '%{0}%'").properties(props -> props.property("objectId").hidden(true).and().property(WebCmsPageConfiguration.CANONICAL_PATH).attribute(TextboxFormElement.Type.class, (Object)TextboxFormElement.Type.TEXT)).listView(lvb -> lvb.showProperties(new String[]{WebCmsPageConfiguration.CANONICAL_PATH, WebCmsPageConfiguration.PAGE_TYPE, "title", "parent"}).defaultSort(WebCmsPageConfiguration.CANONICAL_PATH).entityQueryFilter(true).viewProcessor((EntityViewProcessor)this.pageListViewProcessor())).updateFormView(fvb -> fvb.properties(props -> props.property(WebCmsPageConfiguration.PAGE_TYPE).readable(true).writable(false).order(0).and().property(WebCmsPageConfiguration.PUBLISH_SETTINGS).attribute("com.foreach.across.modules.bootstrapui.elements.FieldsetFormElement.EntityPropertySelector", (Object)EntityPropertySelector.of((String[])new String[]{"published", "publicationDate", "menu-items"})))).createFormView(fvb -> fvb.properties(props -> props.property(WebCmsPageConfiguration.PUBLISH_SETTINGS).and().property(WebCmsPageConfiguration.PAGE_TYPE).order(0))).createOrUpdateFormView(fvb -> fvb.properties(props -> props.property("url-settings").displayName("URL settings").viewElementType(ViewElementMode.FORM_WRITE, "bootstrapFieldset").attribute("com.foreach.across.modules.bootstrapui.elements.FieldsetFormElement.EntityPropertySelector", (Object)EntityPropertySelector.of((String[])new String[]{WebCmsPageConfiguration.PATH_SEGMENT, "pathSegmentGenerated", WebCmsPageConfiguration.CANONICAL_PATH, "canonicalPathGenerated"})).and().property("menu-items").displayName("Auto-create menu items").writable(true).readable(false).hidden(true).viewElementBuilder(ViewElementMode.CONTROL, (ViewElementBuilder)this.menuItemsViewElementBuilder)).showProperties(new String[]{"*", "~canonicalPath", "~canonicalPathGenerated", "~pathSegment", "~pathSegmentGenerated"}).viewProcessor((EntityViewProcessor)this.pageFormViewProcessor)).association(ab -> ab.name("webCmsPage.parent").listView(lvb -> lvb.showProperties(new String[]{WebCmsPageConfiguration.CANONICAL_PATH, "title"}).defaultSort(WebCmsPageConfiguration.CANONICAL_PATH).viewProcessor((EntityViewProcessor)this.pageListViewProcessor())).createOrUpdateFormView(fvb -> fvb.viewProcessor((EntityViewProcessor)this.pageFormViewProcessor)));
        }

        @ConditionalOnAdminUI
        @Bean
        PageListViewProcessor pageListViewProcessor() {
            return new PageListViewProcessor();
        }

        public PageAdminUi(PageFormViewProcessor pageFormViewProcessor, MenuItemsViewElementBuilder menuItemsViewElementBuilder) {
            this.pageFormViewProcessor = pageFormViewProcessor;
            this.menuItemsViewElementBuilder = menuItemsViewElementBuilder;
        }
    }
}

