/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.config;

import com.foreach.across.modules.entity.views.events.BuildEntityDeleteViewEvent;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItemRepository;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import java.util.Collection;
import java.util.List;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class WebCmsPageDeleteEventHandler {
    private final WebCmsAssetEndpointRepository endpointRepository;
    private final WebCmsMenuItemRepository menuItemRepository;

    @EventListener
    public void handleDeleteEvent(BuildEntityDeleteViewEvent<WebCmsPage> event) {
        if (event.getEntity() != null) {
            List<WebCmsAssetEndpoint> endpoints = this.endpointRepository.findAllByAsset((WebCmsAsset)event.getEntity());
            endpoints.forEach(endpointOnPage -> {
                Collection<WebCmsMenuItem> menuItem = this.menuItemRepository.findAllByEndpoint((WebCmsEndpoint)endpointOnPage);
                if (!menuItem.isEmpty()) {
                    event.setDeleteDisabled(true);
                }
            });
        }
    }

    public WebCmsPageDeleteEventHandler(WebCmsAssetEndpointRepository endpointRepository, WebCmsMenuItemRepository menuItemRepository) {
        this.endpointRepository = endpointRepository;
        this.menuItemRepository = menuItemRepository;
    }
}

