/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.services;

import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.WebCmsPageType;
import com.foreach.across.modules.webcms.domain.page.services.PrepareModificationType;
import com.foreach.across.modules.webcms.domain.page.web.PageTypeProperties;
import com.foreach.across.modules.webcms.infrastructure.ModificationReport;
import com.foreach.across.modules.webcms.infrastructure.ModificationStatus;
import com.foreach.across.modules.webcms.infrastructure.ModificationType;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
class PagePropertyGenerator {
    private final PageTypeProperties pageTypeProperties;

    Map<ModificationType, ModificationReport<PrepareModificationType, Object>> prepareForSaving(WebCmsPage page) {
        HashMap<ModificationType, ModificationReport<PrepareModificationType, Object>> modifications = new HashMap<ModificationType, ModificationReport<PrepareModificationType, Object>>();
        this.generatePathSegment(modifications, page);
        this.generateCanonicalPath(modifications, page);
        this.assignDefaultType(modifications, page);
        return modifications;
    }

    private void assignDefaultType(HashMap<ModificationType, ModificationReport<PrepareModificationType, Object>> modifications, WebCmsPage page) {
        if (page.getPageType() == null) {
            page.setPageType(this.pageTypeProperties.getDefaultType());
            modifications.put(PrepareModificationType.PAGE_TYPE_ASSIGNED, new ModificationReport<PrepareModificationType, WebCmsPageType>(PrepareModificationType.PAGE_TYPE_ASSIGNED, ModificationStatus.SUCCESSFUL, null, page.getPageType()));
        }
    }

    private void generatePathSegment(Map<ModificationType, ModificationReport<PrepareModificationType, Object>> modifications, WebCmsPage page) {
        if (page.isPathSegmentGenerated()) {
            String oldSegment = page.getPathSegment();
            String newSegment = WebCmsUtils.generateUrlPathSegment(StringUtils.defaultString((String)page.getTitle()));
            if (!newSegment.equals(oldSegment)) {
                page.setPathSegment(newSegment);
                modifications.put(PrepareModificationType.PATH_SEGMENT_GENERATED, new ModificationReport<PrepareModificationType, String>(PrepareModificationType.PATH_SEGMENT_GENERATED, ModificationStatus.SUCCESSFUL, oldSegment, newSegment));
            }
        }
    }

    private void generateCanonicalPath(Map<ModificationType, ModificationReport<PrepareModificationType, Object>> modifications, WebCmsPage page) {
        if (page.isCanonicalPathGenerated()) {
            String oldCanonicalPath = page.getCanonicalPath();
            String newCanonicalPath = WebCmsUtils.generateCanonicalPath(page);
            if (!newCanonicalPath.equals(oldCanonicalPath)) {
                page.setCanonicalPath(newCanonicalPath);
                modifications.put(PrepareModificationType.CANONICAL_PATH_GENERATED, new ModificationReport<PrepareModificationType, String>(PrepareModificationType.CANONICAL_PATH_GENERATED, ModificationStatus.SUCCESSFUL, oldCanonicalPath, newCanonicalPath));
            }
        }
    }

    public PagePropertyGenerator(PageTypeProperties pageTypeProperties) {
        this.pageTypeProperties = pageTypeProperties;
    }
}

