/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.services;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.WebCmsPageType;
import com.foreach.across.modules.webcms.domain.page.repositories.WebCmsPageRepository;
import com.foreach.across.modules.webcms.domain.page.services.PagePropertyGenerator;
import com.foreach.across.modules.webcms.domain.page.services.PrepareModificationType;
import com.foreach.across.modules.webcms.domain.page.services.WebCmsPageService;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierService;
import com.foreach.across.modules.webcms.infrastructure.ModificationReport;
import com.foreach.across.modules.webcms.infrastructure.ModificationType;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class WebCmsPageServiceImpl
implements WebCmsPageService {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsPageServiceImpl.class);
    private final PagePropertyGenerator pagePropertyGenerator;
    private final WebCmsPageRepository pageRepository;
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsTypeSpecifierService typeSpecifierService;

    @Override
    public WebCmsPageType getPageType(String objectId) {
        return this.typeSpecifierService.getTypeSpecifier(objectId, WebCmsPageType.class);
    }

    @Override
    public WebCmsPageType getPageTypeByKey(String typeKey) {
        return this.typeSpecifierService.getTypeSpecifierByKey(typeKey, WebCmsPageType.class);
    }

    @Override
    public WebCmsPageType getPageTypeByKey(String typeKey, WebCmsDomain domain) {
        return this.typeSpecifierService.getTypeSpecifierByKey(typeKey, WebCmsPageType.class, domain);
    }

    @Override
    public Optional<WebCmsPage> findByCanonicalPath(String canonicalPath) {
        return this.findByCanonicalPathAndDomain(canonicalPath, this.multiDomainService.getCurrentDomainForType(WebCmsPage.class));
    }

    @Override
    public Optional<WebCmsPage> findByCanonicalPathAndDomain(String canonicalPath, WebCmsDomain domain) {
        Optional<WebCmsPage> page = this.pageRepository.findOneByCanonicalPathAndDomain(canonicalPath, domain);
        if (!page.isPresent() && !WebCmsDomain.isNoDomain(domain) && this.multiDomainService.isNoDomainAllowed(WebCmsPage.class)) {
            page = this.pageRepository.findOneByCanonicalPathAndDomain(canonicalPath, WebCmsDomain.NONE);
        }
        return page;
    }

    @Override
    public Map<ModificationType, ModificationReport<PrepareModificationType, Object>> prepareForSaving(WebCmsPage page) {
        return this.pagePropertyGenerator.prepareForSaving(page);
    }

    public WebCmsPageServiceImpl(PagePropertyGenerator pagePropertyGenerator, WebCmsPageRepository pageRepository, WebCmsMultiDomainService multiDomainService, WebCmsTypeSpecifierService typeSpecifierService) {
        this.pagePropertyGenerator = pagePropertyGenerator;
        this.pageRepository = pageRepository;
        this.multiDomainService = multiDomainService;
        this.typeSpecifierService = typeSpecifierService;
    }
}

