/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.validators;

import com.foreach.across.modules.entity.validators.EntityValidatorSupport;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.repositories.WebCmsPageRepository;
import com.foreach.across.modules.webcms.domain.page.services.WebCmsPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class WebCmsPageValidator
extends EntityValidatorSupport<WebCmsPage> {
    private WebCmsPageService pageService;
    private WebCmsPageRepository pageRepository;

    public boolean supports(Class<?> clazz) {
        return WebCmsPage.class.isAssignableFrom(clazz);
    }

    protected void preValidation(WebCmsPage page, Errors errors, Object ... validationHints) {
        this.pageService.prepareForSaving(page);
    }

    protected void postValidation(WebCmsPage page, Errors errors, Object ... validationHints) {
        if (!errors.hasFieldErrors("canonicalPath")) {
            this.pageRepository.findOneByCanonicalPathAndDomain(page.getCanonicalPath(), page.getDomain()).filter(existing -> !page.equals(existing)).ifPresent(e -> errors.rejectValue("canonicalPath", "alreadyExists"));
        }
    }

    @Autowired
    void setPageService(WebCmsPageService pageService) {
        this.pageService = pageService;
    }

    @Autowired
    void setPageRepository(WebCmsPageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }
}

