/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.web;

import com.foreach.across.modules.adminweb.ui.PageContentStructure;
import com.foreach.across.modules.bootstrapui.elements.FormGroupElement;
import com.foreach.across.modules.bootstrapui.elements.LinkViewElement;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.menu.EntityAdminMenuEvent;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.processors.support.EntityPageStructureRenderedEvent;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.hibernate.business.SettableIdBasedEntity;
import com.foreach.across.modules.web.menu.PathBasedMenuBuilder;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElement;
import com.foreach.across.modules.web.ui.elements.TextViewElement;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.WebCmsModuleIcons;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.menu.QWebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenu;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItem;
import com.foreach.across.modules.webcms.domain.menu.WebCmsMenuItemRepository;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.web.PageTypeProperties;
import com.querydsl.core.types.Predicate;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;

@ConditionalOnAdminUI
@Component
public final class PageFormViewProcessor
extends EntityViewProcessorAdapter {
    private final WebCmsAssetService assetPreviewService;
    private final WebCmsAssetEndpointRepository assetEndpointRepository;
    private final WebCmsMenuItemRepository menuItemRepository;
    private final PageTypeProperties pageTypeProperties;
    private final WebCmsMultiDomainService multiDomainService;

    @EventListener
    void setPreviewLinkOnMenu(EntityPageStructureRenderedEvent<WebCmsPage> event) {
        if (event.holdsEntity()) {
            this.assetPreviewService.buildPreviewUrl((WebCmsAsset)event.getEntity()).ifPresent(previewUrl -> {
                LinkViewElement openLink = new LinkViewElement();
                openLink.setAttribute("target", (Object)"_blank");
                openLink.setUrl(previewUrl);
                openLink.setTitle(event.getEntityViewContext().getEntityMessages().withNameSingular("actions.open", new Object[0]));
                openLink.addChild((ViewElement)WebCmsModuleIcons.webCmsIcons.preview());
                PageContentStructure adminPage = event.getPageContentStructure();
                adminPage.addToPageTitleSubText((ViewElement)TextViewElement.html((String)"&nbsp;"));
                adminPage.addToPageTitleSubText((ViewElement)openLink);
            });
        }
    }

    @EventListener
    void handleMenuCreationEvent(EntityAdminMenuEvent<WebCmsPage> event) {
        boolean hasEndpoint;
        if (event.getEntity() != null && ((WebCmsPage)event.getEntity()).getPageType() != null && !(hasEndpoint = ((WebCmsPage)event.getEntity()).getPageType().hasEndpoint())) {
            PathBasedMenuBuilder builder = event.builder();
            event.builder().item("urls").disable().and().item("webCmsMenuItems").disable();
        }
    }

    public void initializeCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, WebDataBinder dataBinder) {
        AdvancedSettings advancedSettings = new AdvancedSettings();
        WebCmsPage page = (WebCmsPage)entityViewRequest.getEntityViewContext().getEntity(WebCmsPage.class);
        WebCmsPage pageFromCommand = (WebCmsPage)command.getEntity(WebCmsPage.class);
        if (page != null) {
            this.assetEndpointRepository.findOneByAssetAndDomain(page, this.multiDomainService.getCurrentDomainForEntity(page)).ifPresent(endpoint -> this.menuItemRepository.findAll((Predicate)QWebCmsMenuItem.webCmsMenuItem.endpoint.eq(endpoint).and((Predicate)QWebCmsMenuItem.webCmsMenuItem.generated.isTrue())).forEach(item -> advancedSettings.getAutoCreateMenu().add(item.getMenu())));
        }
        if (pageFromCommand != null && pageFromCommand.getPageType() == null) {
            pageFromCommand.setPageType(this.pageTypeProperties.getDefaultType());
        }
        command.addExtension("advanced", (Object)advancedSettings);
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            WebCmsPage page = (WebCmsPage)command.getEntity(WebCmsPage.class);
            AdvancedSettings advancedSettings = (AdvancedSettings)command.getExtension("advanced", AdvancedSettings.class);
            this.assetEndpointRepository.findOneByAssetAndDomain(page, this.multiDomainService.getCurrentDomainForEntity(page)).ifPresent(endpoint -> {
                this.menuItemRepository.findAll((Predicate)QWebCmsMenuItem.webCmsMenuItem.endpoint.eq(endpoint)).forEach(item -> {
                    if (!advancedSettings.getAutoCreateMenu().contains(item.getMenu())) {
                        WebCmsMenuItem remove = (WebCmsMenuItem)item.toDto();
                        remove.setGenerated(false);
                        this.menuItemRepository.save((Object)remove);
                    }
                });
                advancedSettings.getAutoCreateMenu().forEach(menu -> {
                    Optional existing = this.menuItemRepository.findOne((Predicate)QWebCmsMenuItem.webCmsMenuItem.menu.eq(menu).and((Predicate)QWebCmsMenuItem.webCmsMenuItem.endpoint.eq(endpoint)));
                    WebCmsMenuItem dto = existing.map(SettableIdBasedEntity::toDto).orElseGet(() -> WebCmsMenuItem.builder().menu((WebCmsMenu)menu).endpoint((WebCmsEndpoint)endpoint).build());
                    dto.setTitle(page.getTitle());
                    dto.setPath(page.getCanonicalPath());
                    dto.setGenerated(true);
                    this.menuItemRepository.save((Object)dto);
                });
            });
        }
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        this.addDependency(container, "pathSegment", "pathSegmentGenerated");
        this.addDependency(container, "canonicalPath", "canonicalPathGenerated");
        ContainerViewElementUtils.move((ContainerViewElement)container, (String)"publish-settings", (String)"entityForm-column-1");
        ContainerViewElementUtils.find((ContainerViewElement)container, (String)"formGroup-menu-items", FormGroupElement.class).ifPresent(group -> {
            if (!((ContainerViewElement)group.getControl(ContainerViewElement.class)).hasChildren()) {
                ContainerViewElementUtils.remove((ContainerViewElement)container, (String)"formGroup-menu-items");
            }
        });
        WebCmsPage page = (WebCmsPage)entityViewRequest.getEntityViewContext().getEntity(WebCmsPage.class);
        if (page != null && page.getPageType() != null && !page.getPageType().isPublishable()) {
            ContainerViewElementUtils.remove((ContainerViewElement)container, (String)"publish-settings");
        }
    }

    private void addDependency(ContainerViewElement elements, String from, String to) {
        ContainerViewElementUtils.find((ContainerViewElement)elements, (String)("formGroup-" + from), FormGroupElement.class).ifPresent(group -> {
            HashMap<String, Boolean> qualifiers = new HashMap<String, Boolean>();
            qualifiers.put("checked", false);
            HtmlViewElement element = (HtmlViewElement)group.getControl(HtmlViewElement.class);
            element.setAttribute("data-dependson", Collections.singletonMap("[id='entity." + to + "']", qualifiers));
        });
    }

    public PageFormViewProcessor(WebCmsAssetService assetPreviewService, WebCmsAssetEndpointRepository assetEndpointRepository, WebCmsMenuItemRepository menuItemRepository, PageTypeProperties pageTypeProperties, WebCmsMultiDomainService multiDomainService) {
        this.assetPreviewService = assetPreviewService;
        this.assetEndpointRepository = assetEndpointRepository;
        this.menuItemRepository = menuItemRepository;
        this.pageTypeProperties = pageTypeProperties;
        this.multiDomainService = multiDomainService;
    }

    static class AdvancedSettings {
        private Set<WebCmsMenu> autoCreateMenu = new HashSet<WebCmsMenu>();

        public Set<WebCmsMenu> getAutoCreateMenu() {
            return this.autoCreateMenu;
        }

        public void setAutoCreateMenu(Set<WebCmsMenu> autoCreateMenu) {
            this.autoCreateMenu = autoCreateMenu;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdvancedSettings)) {
                return false;
            }
            AdvancedSettings other = (AdvancedSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<WebCmsMenu> this$autoCreateMenu = this.getAutoCreateMenu();
            Set<WebCmsMenu> other$autoCreateMenu = other.getAutoCreateMenu();
            return !(this$autoCreateMenu == null ? other$autoCreateMenu != null : !((Object)this$autoCreateMenu).equals(other$autoCreateMenu));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdvancedSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<WebCmsMenu> $autoCreateMenu = this.getAutoCreateMenu();
            result = result * 59 + ($autoCreateMenu == null ? 43 : ((Object)$autoCreateMenu).hashCode());
            return result;
        }

        public String toString() {
            return "PageFormViewProcessor.AdvancedSettings(autoCreateMenu=" + this.getAutoCreateMenu() + ")";
        }
    }
}

