/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.web;

import com.foreach.across.core.DynamicAcrossModule;
import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.core.context.info.AcrossModuleInfo;
import com.foreach.across.core.events.AcrossContextBootstrappedEvent;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.web.PageTemplateProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Exposed
@Component
@EnableConfigurationProperties(value={PageTemplateProperties.class})
public class PageTemplateResolver {
    private static final Logger LOG = LoggerFactory.getLogger(PageTemplateResolver.class);
    private final PageTemplateProperties properties;

    public String resolvePageTemplate(WebCmsPage page) {
        if (StringUtils.isBlank((CharSequence)page.getTemplate())) {
            if (page.getPageType().getTemplate() != null) {
                return this.resolvePageTemplate(page.getPageType().getTemplate());
            }
            return this.properties.getDefaultTemplate();
        }
        return this.resolvePageTemplate(page.getTemplate());
    }

    public String resolvePageTemplate(String template) {
        if (StringUtils.isBlank((CharSequence)template)) {
            return this.properties.getDefaultTemplate();
        }
        if (StringUtils.startsWithAny((CharSequence)template, (CharSequence[])this.properties.getTemplatePrefixToIgnore())) {
            return StringUtils.removeEnd((String)template, (String)this.properties.getTemplateSuffixToRemove());
        }
        return StringUtils.removeEnd((String)StringUtils.replace((String)(StringUtils.defaultString((String)this.properties.getTemplatePrefix()) + template), (String)"//", (String)"/"), (String)this.properties.getTemplateSuffixToRemove());
    }

    @EventListener
    void determineDefaultPrefix(AcrossContextBootstrappedEvent contextBootstrappedEvent) {
        if (this.properties.getTemplatePrefix() == null) {
            contextBootstrappedEvent.getModules().stream().filter(m -> m.isBootstrapped() && m.getModule() instanceof DynamicAcrossModule).findFirst().map(AcrossModuleInfo::getModule).ifPresent(m -> {
                String prefix = "th/" + m.getResourcesKey() + "/";
                LOG.info("No default WebCmsPage template prefix configured - using {}", (Object)prefix);
                this.properties.setTemplatePrefix(prefix);
            });
        }
    }

    public PageTemplateResolver(PageTemplateProperties properties) {
        this.properties = properties;
    }
}

