/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.web;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainRepository;
import com.foreach.across.modules.webcms.domain.domain.config.WebCmsMultiDomainConfiguration;
import com.foreach.across.modules.webcms.domain.page.WebCmsPageType;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="web-cms-module.pages")
public class PageTypeProperties {
    private static final Logger LOG = LoggerFactory.getLogger(PageTypeProperties.class);
    private static final String DEFAULT_PAGE_TYPE_TYPE_KEY = "default";
    private final WebCmsTypeSpecifierService typeSpecifierService;
    private final WebCmsDomainRepository domainRepository;
    private final WebCmsMultiDomainConfiguration multiDomainConfiguration;
    private String defaultPageType = "default";

    public WebCmsPageType getDefaultType() {
        String keyOrObjectId = this.getDefaultPageType();
        if (StringUtils.isBlank((CharSequence)keyOrObjectId)) {
            LOG.warn("No default page type configured - assuming {}", (Object)DEFAULT_PAGE_TYPE_TYPE_KEY);
            keyOrObjectId = DEFAULT_PAGE_TYPE_TYPE_KEY;
        }
        WebCmsDomain defaultDomain = this.domainRepository.findOneByDomainKey(this.multiDomainConfiguration.getDefaultDomainKey()).orElse(null);
        WebCmsPageType defaultPageType = this.typeSpecifierService.getTypeSpecifier(keyOrObjectId, WebCmsPageType.class);
        if (defaultPageType == null) {
            defaultPageType = this.typeSpecifierService.getTypeSpecifierByKey(keyOrObjectId, WebCmsPageType.class, defaultDomain);
        }
        if (defaultPageType == null) {
            LOG.error("Could not resolve default page type with typeKey (domain: null) or objectId {}", (Object)keyOrObjectId);
        }
        return defaultPageType;
    }

    public WebCmsTypeSpecifierService getTypeSpecifierService() {
        return this.typeSpecifierService;
    }

    public WebCmsDomainRepository getDomainRepository() {
        return this.domainRepository;
    }

    public WebCmsMultiDomainConfiguration getMultiDomainConfiguration() {
        return this.multiDomainConfiguration;
    }

    public String getDefaultPageType() {
        return this.defaultPageType;
    }

    public void setDefaultPageType(String defaultPageType) {
        this.defaultPageType = defaultPageType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageTypeProperties)) {
            return false;
        }
        PageTypeProperties other = (PageTypeProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WebCmsTypeSpecifierService this$typeSpecifierService = this.getTypeSpecifierService();
        WebCmsTypeSpecifierService other$typeSpecifierService = other.getTypeSpecifierService();
        if (this$typeSpecifierService == null ? other$typeSpecifierService != null : !this$typeSpecifierService.equals(other$typeSpecifierService)) {
            return false;
        }
        WebCmsDomainRepository this$domainRepository = this.getDomainRepository();
        WebCmsDomainRepository other$domainRepository = other.getDomainRepository();
        if (this$domainRepository == null ? other$domainRepository != null : !this$domainRepository.equals(other$domainRepository)) {
            return false;
        }
        WebCmsMultiDomainConfiguration this$multiDomainConfiguration = this.getMultiDomainConfiguration();
        WebCmsMultiDomainConfiguration other$multiDomainConfiguration = other.getMultiDomainConfiguration();
        if (this$multiDomainConfiguration == null ? other$multiDomainConfiguration != null : !((Object)this$multiDomainConfiguration).equals(other$multiDomainConfiguration)) {
            return false;
        }
        String this$defaultPageType = this.getDefaultPageType();
        String other$defaultPageType = other.getDefaultPageType();
        return !(this$defaultPageType == null ? other$defaultPageType != null : !this$defaultPageType.equals(other$defaultPageType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageTypeProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WebCmsTypeSpecifierService $typeSpecifierService = this.getTypeSpecifierService();
        result = result * 59 + ($typeSpecifierService == null ? 43 : $typeSpecifierService.hashCode());
        WebCmsDomainRepository $domainRepository = this.getDomainRepository();
        result = result * 59 + ($domainRepository == null ? 43 : $domainRepository.hashCode());
        WebCmsMultiDomainConfiguration $multiDomainConfiguration = this.getMultiDomainConfiguration();
        result = result * 59 + ($multiDomainConfiguration == null ? 43 : ((Object)$multiDomainConfiguration).hashCode());
        String $defaultPageType = this.getDefaultPageType();
        result = result * 59 + ($defaultPageType == null ? 43 : $defaultPageType.hashCode());
        return result;
    }

    public String toString() {
        return "PageTypeProperties(typeSpecifierService=" + this.getTypeSpecifierService() + ", domainRepository=" + this.getDomainRepository() + ", multiDomainConfiguration=" + this.getMultiDomainConfiguration() + ", defaultPageType=" + this.getDefaultPageType() + ")";
    }

    public PageTypeProperties(WebCmsTypeSpecifierService typeSpecifierService, WebCmsDomainRepository domainRepository, WebCmsMultiDomainConfiguration multiDomainConfiguration) {
        this.typeSpecifierService = typeSpecifierService;
        this.domainRepository = domainRepository;
        this.multiDomainConfiguration = multiDomainConfiguration;
    }
}

