/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.page.web;

import com.foreach.across.modules.web.mvc.condition.AbstractCustomRequestCondition;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.web.WebCmsEndpointContextResolver;
import com.foreach.across.modules.webcms.domain.endpoint.web.context.ConfigurableWebCmsEndpointContext;
import com.foreach.across.modules.webcms.domain.endpoint.web.controllers.WebCmsConditionUtils;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.page.web.WebCmsPageMapping;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

final class WebCmsPageCondition
extends AbstractCustomRequestCondition<WebCmsPageCondition> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsPageCondition.class);
    private final ConfigurableWebCmsEndpointContext context;
    private final WebCmsEndpointContextResolver resolver;
    private String[] canonicalPath = new String[0];
    private String[] pageType = new String[0];
    private String[] objectId = new String[0];

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        WebCmsPageMapping endpointMapping = (WebCmsPageMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, WebCmsPageMapping.class);
        this.canonicalPath = endpointMapping.canonicalPath();
        this.pageType = endpointMapping.pageType();
        this.objectId = endpointMapping.objectId();
    }

    protected Collection<?> getContent() {
        return Arrays.asList(this.canonicalPath, this.pageType);
    }

    protected String getToStringInfix() {
        return " && ";
    }

    public WebCmsPageCondition combine(WebCmsPageCondition other) {
        if (!this.context.isOfType(WebCmsAssetEndpoint.class)) {
            return null;
        }
        WebCmsPageCondition result = new WebCmsPageCondition(this.context, this.resolver);
        result.canonicalPath = WebCmsConditionUtils.combineArrays(this.canonicalPath, other.canonicalPath);
        result.pageType = WebCmsConditionUtils.combineArrays(this.pageType, other.pageType);
        result.objectId = WebCmsConditionUtils.combineArrays(this.objectId, other.objectId);
        return result;
    }

    public WebCmsPageCondition getMatchingCondition(HttpServletRequest request) {
        if (!this.context.isResolved()) {
            this.resolver.resolve(this.context, request);
        }
        Object rawAsset = this.context.getEndpoint(WebCmsAssetEndpoint.class).getAsset();
        if (this.context.isOfType(WebCmsAssetEndpoint.class) && WebCmsPage.class.isInstance(rawAsset)) {
            WebCmsPage page = (WebCmsPage)rawAsset;
            if (!this.isValidCanonicalPath(page) || !this.isValidPageType(page)) {
                return null;
            }
            LOG.trace("Matching condition is {}", (Object)this);
            return this;
        }
        return null;
    }

    private boolean isValidPageType(WebCmsPage page) {
        if (this.pageType.length > 0 && page.getPageType() != null) {
            return ArrayUtils.contains((Object[])this.pageType, (Object)page.getPageType().getTypeKey()) || ArrayUtils.contains((Object[])this.pageType, (Object)page.getPageType().getObjectId());
        }
        return true;
    }

    private boolean isValidCanonicalPath(WebCmsPage page) {
        if (this.canonicalPath.length > 0) {
            return ArrayUtils.contains((Object[])this.canonicalPath, (Object)page.getCanonicalPath());
        }
        return true;
    }

    public int compareTo(WebCmsPageCondition other, HttpServletRequest request) {
        int val2 = WebCmsConditionUtils.compareArrays(this.objectId, other.objectId);
        if (val2 == 0) {
            val2 = WebCmsConditionUtils.compareArrays(this.canonicalPath, other.canonicalPath);
        }
        if (val2 == 0) {
            val2 = WebCmsConditionUtils.compareArrays(this.pageType, other.pageType);
        }
        return val2;
    }

    public WebCmsPageCondition(ConfigurableWebCmsEndpointContext context, WebCmsEndpointContextResolver resolver) {
        this.context = context;
        this.resolver = resolver;
    }
}

