/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationRepository;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationService;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class MapToWebCmsPublicationConverter
implements Converter<Map<String, Object>, WebCmsPublication> {
    private final WebCmsPublicationRepository publicationRepository;
    private final WebCmsDataConversionService conversionService;
    private final WebCmsPublicationService publicationService;

    @Autowired
    void register(WebCmsDataConversionService conversionService) {
        conversionService.addConverter(this);
    }

    public WebCmsPublication convert(Map<String, Object> data) {
        if (data.containsKey("objectId")) {
            return this.publicationRepository.findOneByObjectId(Objects.toString(data.get("objectId"))).orElse(null);
        }
        if (data.containsKey("publicationKey")) {
            String typeKey = Objects.toString(data.get("publicationKey"));
            if (data.containsKey("domain")) {
                return this.publicationService.getPublicationByKey(typeKey, (WebCmsDomain)this.conversionService.convert(data.get("domain"), WebCmsDomain.class));
            }
            return this.publicationService.getPublicationByKey(typeKey);
        }
        return null;
    }

    public MapToWebCmsPublicationConverter(WebCmsPublicationRepository publicationRepository, WebCmsDataConversionService conversionService, WebCmsPublicationService publicationService) {
        this.publicationRepository = publicationRepository;
        this.conversionService = conversionService;
        this.publicationService = publicationService;
    }
}

