/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationRepository;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationService;
import com.foreach.across.modules.webcms.infrastructure.WebCmsUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public final class StringToWebCmsPublicationConverter
implements Converter<String, WebCmsPublication> {
    private final WebCmsPublicationRepository publicationRepository;
    private final WebCmsPublicationService publicationService;

    @Autowired
    void register(WebCmsDataConversionService conversionService) {
        conversionService.addConverter(this);
    }

    public WebCmsPublication convert(String source) {
        if (NumberUtils.isDigits((String)source)) {
            return this.publicationRepository.findById(Long.parseLong(source)).orElse(null);
        }
        if (WebCmsUtils.isObjectIdForCollection(source, "wcm:asset:publication")) {
            return this.publicationRepository.findOneByObjectId(source).orElse(null);
        }
        return this.publicationService.getPublicationByKey(source);
    }

    public StringToWebCmsPublicationConverter(WebCmsPublicationRepository publicationRepository, WebCmsPublicationService publicationService) {
        this.publicationRepository = publicationRepository;
        this.publicationService = publicationService;
    }
}

