/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication;

import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationType;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;

@Entity
@DiscriminatorValue(value="publication")
@Table(name="wcm_publication")
@NotThreadSafe
public class WebCmsPublication
extends WebCmsAsset<WebCmsPublication> {
    public static final String OBJECT_TYPE = "publication";
    public static final String COLLECTION_ID = "wcm:asset:publication";
    @NotBlank
    @Length(max=255)
    @Column(name="name", unique=true)
    private @NotBlank @Length(max=255) String name;
    @NotBlank
    @Length(max=255)
    @Column(name="publication_key")
    @Pattern(regexp="[^\\s]*")
    private @NotBlank @Length(max=255) @Pattern(regexp="[^\\s]*") String publicationKey;
    @NotNull
    @ManyToOne(optional=false)
    @JoinColumn(name="publication_type_id")
    private WebCmsPublicationType publicationType;
    @ManyToOne
    @JoinColumn(name="article_page_id")
    private WebCmsPage articleTemplatePage;

    protected WebCmsPublication(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain, boolean published, Date publicationDate, int sortIndex, String name, String publicationKey, WebCmsPublicationType publicationType, WebCmsPage articleTemplatePage) {
        super(id, newEntityId, objectId, createdBy, createdDate, lastModifiedBy, lastModifiedDate, domain, published, publicationDate, sortIndex);
        this.name = name;
        this.publicationKey = publicationKey;
        this.publicationType = publicationType;
        this.articleTemplatePage = articleTemplatePage;
    }

    @Override
    public final String getObjectType() {
        return OBJECT_TYPE;
    }

    @Override
    protected final String getObjectCollectionId() {
        return COLLECTION_ID;
    }

    @Override
    public WebCmsPublicationType getAssetType() {
        return this.publicationType;
    }

    public static WebCmsPublicationBuilder builder() {
        return new WebCmsPublicationBuilder();
    }

    public WebCmsPublicationBuilder toBuilder() {
        Long id = this.getId();
        Long newEntityId = this.getNewEntityId();
        String objectId = this.getObjectId();
        String createdBy = this.getCreatedBy();
        Date createdDate = this.getCreatedDate();
        String lastModifiedBy = this.getLastModifiedBy();
        Date lastModifiedDate = this.getLastModifiedDate();
        WebCmsDomain domain = this.getDomain();
        boolean published = this.isPublished();
        Date publicationDate = this.getPublicationDate();
        int sortIndex = this.getSortIndex();
        return new WebCmsPublicationBuilder().id(id).newEntityId(newEntityId).objectId(objectId).createdBy(createdBy).createdDate(createdDate).lastModifiedBy(lastModifiedBy).lastModifiedDate(lastModifiedDate).domain(domain).published(published).publicationDate(publicationDate).sortIndex(sortIndex).name(this.name).publicationKey(this.publicationKey).publicationType(this.publicationType).articleTemplatePage(this.articleTemplatePage);
    }

    public WebCmsPublication() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPublicationKey() {
        return this.publicationKey;
    }

    public WebCmsPublicationType getPublicationType() {
        return this.publicationType;
    }

    public WebCmsPage getArticleTemplatePage() {
        return this.articleTemplatePage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPublicationKey(String publicationKey) {
        this.publicationKey = publicationKey;
    }

    public void setPublicationType(WebCmsPublicationType publicationType) {
        this.publicationType = publicationType;
    }

    public void setArticleTemplatePage(WebCmsPage articleTemplatePage) {
        this.articleTemplatePage = articleTemplatePage;
    }

    public static class WebCmsPublicationBuilder {
        private Long id;
        private Long newEntityId;
        private String objectId;
        private String createdBy;
        private Date createdDate;
        private String lastModifiedBy;
        private Date lastModifiedDate;
        private WebCmsDomain domain;
        private boolean published;
        private Date publicationDate;
        private String name;
        private String publicationKey;
        private WebCmsPublicationType publicationType;
        private WebCmsPage articleTemplatePage;
        private int sortIndex = 1000;

        WebCmsPublicationBuilder() {
        }

        public WebCmsPublicationBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsPublicationBuilder newEntityId(Long newEntityId) {
            this.newEntityId = newEntityId;
            return this;
        }

        public WebCmsPublicationBuilder objectId(String objectId) {
            this.objectId = objectId;
            return this;
        }

        public WebCmsPublicationBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public WebCmsPublicationBuilder createdDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public WebCmsPublicationBuilder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public WebCmsPublicationBuilder lastModifiedDate(Date lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public WebCmsPublicationBuilder domain(WebCmsDomain domain) {
            this.domain = domain;
            return this;
        }

        public WebCmsPublicationBuilder published(boolean published) {
            this.published = published;
            return this;
        }

        public WebCmsPublicationBuilder publicationDate(Date publicationDate) {
            this.publicationDate = publicationDate;
            return this;
        }

        public WebCmsPublicationBuilder sortIndex(int sortIndex) {
            this.sortIndex = sortIndex;
            return this;
        }

        public WebCmsPublicationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public WebCmsPublicationBuilder publicationKey(String publicationKey) {
            this.publicationKey = publicationKey;
            return this;
        }

        public WebCmsPublicationBuilder publicationType(WebCmsPublicationType publicationType) {
            this.publicationType = publicationType;
            return this;
        }

        public WebCmsPublicationBuilder articleTemplatePage(WebCmsPage articleTemplatePage) {
            this.articleTemplatePage = articleTemplatePage;
            return this;
        }

        public WebCmsPublication build() {
            return new WebCmsPublication(this.id, this.newEntityId, this.objectId, this.createdBy, this.createdDate, this.lastModifiedBy, this.lastModifiedDate, this.domain, this.published, this.publicationDate, this.sortIndex, this.name, this.publicationKey, this.publicationType, this.articleTemplatePage);
        }

        public String toString() {
            return "WebCmsPublication.WebCmsPublicationBuilder(id=" + this.id + ", newEntityId=" + this.newEntityId + ", objectId=" + this.objectId + ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", lastModifiedBy=" + this.lastModifiedBy + ", lastModifiedDate=" + this.lastModifiedDate + ", domain=" + this.domain + ", published=" + this.published + ", publicationDate=" + this.publicationDate + ", sortIndex=" + this.sortIndex + ", name=" + this.name + ", publicationKey=" + this.publicationKey + ", publicationType=" + this.publicationType + ", articleTemplatePage=" + this.articleTemplatePage + ")";
        }
    }
}

