/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication;

import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.asset.AbstractWebCmsAssetImporter;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.publication.QWebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationRepository;
import com.foreach.across.modules.webcms.domain.publication.web.WebCmsPublicationValidator;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public final class WebCmsPublicationImporter
extends AbstractWebCmsAssetImporter<WebCmsPublication> {
    private WebCmsPublicationRepository publicationRepository;
    private WebCmsPublicationValidator publicationValidator;

    public WebCmsPublicationImporter() {
        super("publication", WebCmsPublication.class);
    }

    @Override
    protected WebCmsPublication createDto(WebCmsDataEntry data, WebCmsPublication itemToUpdate, WebCmsDataAction action, Map<String, Object> dataValues) {
        if (action == WebCmsDataAction.REPLACE) {
            return WebCmsPublication.builder().id(itemToUpdate.getId()).createdBy(itemToUpdate.getCreatedBy()).createdDate(itemToUpdate.getCreatedDate()).objectId(itemToUpdate.getObjectId()).build();
        }
        return itemToUpdate != null ? (WebCmsPublication)itemToUpdate.toDto() : new WebCmsPublication();
    }

    @Override
    protected WebCmsPublication prepareForSaving(WebCmsPublication itemToBeSaved, WebCmsDataEntry data) {
        if (itemToBeSaved.isNew() && itemToBeSaved.getPublicationKey() == null) {
            itemToBeSaved.setPublicationKey(data.getKey());
        }
        return itemToBeSaved;
    }

    @Override
    protected WebCmsPublication getExistingEntity(String entryKey, WebCmsDataEntry data, WebCmsDomain domain) {
        if (StringUtils.isEmpty((CharSequence)entryKey)) {
            if (!data.getMapData().containsKey("publicationKey")) {
                return null;
            }
            entryKey = (String)data.getMapData().get("publicationKey");
        }
        QWebCmsPublication query = QWebCmsPublication.webCmsPublication;
        BooleanBuilder builder = new BooleanBuilder();
        if (domain != null) {
            builder.and((Predicate)query.domain.eq(domain));
        }
        return this.publicationRepository.findOne((Predicate)builder.and((Predicate)query.publicationKey.eq((Object)entryKey))).orElse(null);
    }

    @Override
    protected void validate(WebCmsPublication itemToBeSaved, Errors errors) {
        this.publicationValidator.validate(itemToBeSaved, errors);
    }

    @Autowired
    void setPublicationRepository(WebCmsPublicationRepository publicationRepository) {
        this.publicationRepository = publicationRepository;
    }

    @Autowired
    void setPublicationValidator(WebCmsPublicationValidator publicationValidator) {
        this.publicationValidator = publicationValidator;
    }
}

