/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationRepository;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationService;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
class WebCmsPublicationServiceImpl
implements WebCmsPublicationService {
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsPublicationRepository publicationRepository;

    @Override
    public WebCmsPublication getPublicationByKey(String publicationKey) {
        return this.getPublicationByKey(publicationKey, this.multiDomainService.getCurrentDomainForEntity(WebCmsPublication.class));
    }

    @Override
    public WebCmsPublication getPublicationByKey(String publicationKey, WebCmsDomain domain) {
        Assert.notNull((Object)publicationKey, (String)"Publication key is required");
        WebCmsPublication candidate = this.publicationRepository.findOneByPublicationKeyAndDomain(publicationKey, domain).orElse(null);
        if (candidate == null && !WebCmsDomain.isNoDomain(domain) && this.multiDomainService.isNoDomainAllowed(WebCmsPublication.class)) {
            candidate = this.publicationRepository.findOneByPublicationKeyAndDomain(publicationKey, WebCmsDomain.NONE).orElse(null);
        }
        return candidate;
    }

    public WebCmsPublicationServiceImpl(WebCmsMultiDomainService multiDomainService, WebCmsPublicationRepository publicationRepository) {
        this.multiDomainService = multiDomainService;
        this.publicationRepository = publicationRepository;
    }
}

