/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication.config;

import com.foreach.across.modules.entity.EntityAttributes;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.support.ValueFetcher;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticleType;
import com.foreach.across.modules.webcms.domain.asset.web.processors.WebCmsAssetListViewProcessor;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationType;
import com.foreach.across.modules.webcms.domain.publication.web.PublicationTypeFormProcessor;
import java.util.Set;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;

@ConditionalOnAdminUI
@Configuration
class WebCmsPublicationConfiguration
implements EntityConfigurer {
    private final PublicationTypeFormProcessor publicationTypeFormProcessor;

    public void configure(EntitiesConfigurationBuilder entities) {
        entities.withType(WebCmsPage.class).association(ab -> ab.name("webCmsPublication.articleTemplatePage").hide());
        entities.withType(WebCmsPublicationType.class).properties(props -> props.property("articleTypes").displayName("Article types").propertyType(TypeDescriptor.collection(Set.class, (TypeDescriptor)TypeDescriptor.valueOf(WebCmsArticleType.class))).attribute(EntityAttributes.CONTROL_NAME, (Object)"extensions[articleTypes].allowed").valueFetcher((ValueFetcher)this.publicationTypeFormProcessor).writable(true).readable(false)).createOrUpdateFormView(fvb -> fvb.showProperties(new String[]{".", "articleTypes"}).viewProcessor((EntityViewProcessor)this.publicationTypeFormProcessor)).association(ab -> ab.name("webCmsPublication.publicationType").listView(lvb -> lvb.showProperties(new String[]{"name", "publicationKey", "articleTemplatePage", "lastModified"}).viewProcessor((EntityViewProcessor)new WebCmsAssetListViewProcessor())));
        entities.withType(WebCmsPublication.class).properties(props -> props.property("objectId").order(0).writable(false).and().property("publish-settings").hidden(true).and().property("published").hidden(false)).updateFormView(fvb -> fvb.showProperties(new String[]{"objectId", "*", "created", "lastModified"})).listView(lvb -> lvb.showProperties(new String[]{"name", "publicationKey", "publicationType", "articleTemplatePage", "lastModified"})).association(ab -> ab.name("webCmsArticle.publication").listView(lvb -> lvb.showProperties(new String[]{"title", "articleType", "publicationDate", "lastModified"}).viewProcessor((EntityViewProcessor)new WebCmsAssetListViewProcessor())));
    }

    public WebCmsPublicationConfiguration(PublicationTypeFormProcessor publicationTypeFormProcessor) {
        this.publicationTypeFormProcessor = publicationTypeFormProcessor;
    }
}

