/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication.web;

import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.views.support.ValueFetcher;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.article.WebCmsArticleType;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLink;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLinkRepository;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;

@ConditionalOnAdminUI
@Component
public class PublicationTypeFormProcessor
extends EntityViewProcessorAdapter
implements ValueFetcher<WebCmsObject> {
    public static final String ARTICLE_TYPES_CONTROL_NAME = "extensions[articleTypes].allowed";
    private final EntityViewRequest entityViewRequest;
    private final WebCmsTypeSpecifierLinkRepository typeLinkRepository;

    public void initializeCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, WebDataBinder dataBinder) {
        command.addExtension("articleTypes", (Object)new ArticleTypesHolder());
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            WebCmsObject owner = (WebCmsObject)command.getEntity(WebCmsObject.class);
            ArticleTypesHolder typesHolder = (ArticleTypesHolder)command.getExtension("articleTypes", ArticleTypesHolder.class);
            Map currentLinks = this.typeLinkRepository.findAllByOwnerObjectIdAndLinkTypeOrderBySortIndexAsc(owner.getObjectId(), "article").stream().collect(Collectors.toMap(WebCmsTypeSpecifierLink::getTypeSpecifier, Function.identity()));
            ArrayList linksToCreate = new ArrayList();
            typesHolder.getAllowed().forEach(articleType -> {
                if (currentLinks.remove(articleType) == null) {
                    WebCmsTypeSpecifierLink link = new WebCmsTypeSpecifierLink();
                    link.setOwner(owner);
                    link.setTypeSpecifier((WebCmsTypeSpecifier)articleType);
                    link.setLinkType("article");
                    linksToCreate.add(link);
                }
            });
            currentLinks.values().forEach(arg_0 -> ((WebCmsTypeSpecifierLinkRepository)this.typeLinkRepository).delete(arg_0));
            linksToCreate.forEach(arg_0 -> ((WebCmsTypeSpecifierLinkRepository)this.typeLinkRepository).save(arg_0));
        }
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        ContainerViewElementUtils.move((ContainerViewElement)container, (String)"formGroup-articleTypes", (String)"entityForm-column-1");
    }

    public Object getValue(WebCmsObject entity) {
        if (this.entityViewRequest.getHttpMethod() == HttpMethod.POST && this.entityViewRequest.getCommand().hasExtension("articleTypes")) {
            return ((ArticleTypesHolder)this.entityViewRequest.getCommand().getExtension((String)"articleTypes", ArticleTypesHolder.class)).allowed;
        }
        return entity.isNew() ? Collections.emptySet() : this.typeLinkRepository.findAllByOwnerObjectIdAndLinkTypeOrderBySortIndexAsc(entity.getObjectId(), "article").stream().map(WebCmsTypeSpecifierLink::getTypeSpecifier).collect(Collectors.toSet());
    }

    public PublicationTypeFormProcessor(EntityViewRequest entityViewRequest, WebCmsTypeSpecifierLinkRepository typeLinkRepository) {
        this.entityViewRequest = entityViewRequest;
        this.typeLinkRepository = typeLinkRepository;
    }

    class ArticleTypesHolder {
        Set<WebCmsArticleType> allowed = new HashSet<WebCmsArticleType>();

        public Set<WebCmsArticleType> getAllowed() {
            return this.allowed;
        }

        public void setAllowed(Set<WebCmsArticleType> allowed) {
            this.allowed = allowed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArticleTypesHolder)) {
                return false;
            }
            ArticleTypesHolder other = (ArticleTypesHolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<WebCmsArticleType> this$allowed = this.getAllowed();
            Set<WebCmsArticleType> other$allowed = other.getAllowed();
            return !(this$allowed == null ? other$allowed != null : !((Object)this$allowed).equals(other$allowed));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArticleTypesHolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<WebCmsArticleType> $allowed = this.getAllowed();
            result = result * 59 + ($allowed == null ? 43 : ((Object)$allowed).hashCode());
            return result;
        }

        public String toString() {
            return "PublicationTypeFormProcessor.ArticleTypesHolder(allowed=" + this.getAllowed() + ")";
        }
    }
}

