/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.publication.web;

import com.foreach.across.modules.entity.validators.EntityValidatorSupport;
import com.foreach.across.modules.webcms.domain.publication.QWebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublication;
import com.foreach.across.modules.webcms.domain.publication.WebCmsPublicationRepository;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
@Order(value=0x7FFFFFFF)
public final class WebCmsPublicationValidator
extends EntityValidatorSupport<WebCmsPublication> {
    private final WebCmsPublicationRepository publicationRepository;

    public boolean supports(Class<?> clazz) {
        return WebCmsPublication.class.isAssignableFrom(clazz);
    }

    protected void postValidation(WebCmsPublication entity, Errors errors, Object ... validationHints) {
        if (!errors.hasFieldErrors("name")) {
            QWebCmsPublication query = QWebCmsPublication.webCmsPublication;
            BooleanBuilder builder = new BooleanBuilder();
            if (entity.getDomain() != null) {
                builder.and((Predicate)query.domain.eq(entity.getDomain()));
            }
            this.publicationRepository.findOne((Predicate)builder.and((Predicate)query.name.equalsIgnoreCase(entity.getName()))).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("name", "alreadyExists"));
        }
        if (!errors.hasFieldErrors("publicationKey")) {
            this.publicationRepository.findOneByPublicationKeyAndDomain(entity.getPublicationKey(), entity.getDomain()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("publicationKey", "alreadyExists"));
        }
        if (!errors.hasFieldErrors("publicationKey") && !errors.hasFieldErrors("objectId")) {
            this.publicationRepository.findOneByObjectId(entity.getObjectId()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("objectId", "alreadyExists"));
        }
    }

    public WebCmsPublicationValidator(WebCmsPublicationRepository publicationRepository) {
        this.publicationRepository = publicationRepository;
    }
}

