/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.redirect;

import com.foreach.across.modules.webcms.data.AbstractWebCmsDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointRepository;
import com.foreach.across.modules.webcms.domain.redirect.WebCmsRemoteEndpoint;
import com.foreach.across.modules.webcms.domain.redirect.WebCmsRemoteEndpointRepository;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class WebCmsRemoteEndpointImporter
extends AbstractWebCmsDataImporter<WebCmsEndpoint, WebCmsEndpoint> {
    private final WebCmsRemoteEndpointRepository remoteEndpointRepository;
    private final WebCmsEndpointRepository endpointRepository;

    @Override
    public boolean supports(WebCmsDataEntry data) {
        return "redirects".equals(data.getParentKey());
    }

    @Override
    protected WebCmsEndpoint retrieveExistingInstance(WebCmsDataEntry data) {
        WebCmsDomain domain = this.retrieveDomainForDataEntry(data, WebCmsRemoteEndpoint.class);
        String targetUrl = data.getMapData().containsKey("targetUrl") ? (String)data.getMapData().get("targetUrl") : data.getKey();
        return this.remoteEndpointRepository.findOneByTargetUrlAndDomain(targetUrl, domain).orElse(null);
    }

    @Override
    protected WebCmsEndpoint createDto(WebCmsDataEntry data, WebCmsEndpoint existing, WebCmsDataAction action, Map<String, Object> dataValues) {
        if (existing != null) {
            if (action == WebCmsDataAction.REPLACE) {
                WebCmsRemoteEndpoint endpoint = this.createNewRemoteEndpointDto(data);
                if (endpoint != null) {
                    endpoint.setId(existing.getId());
                }
                return endpoint;
            }
            return (WebCmsEndpoint)existing.toDto();
        }
        return this.createNewRemoteEndpointDto(data);
    }

    private WebCmsRemoteEndpoint createNewRemoteEndpointDto(WebCmsDataEntry data) {
        String targetUrl = data.getMapData().containsKey("targetUrl") ? (String)data.getMapData().get("targetUrl") : data.getKey();
        return WebCmsRemoteEndpoint.builder().targetUrl(targetUrl).build();
    }

    @Override
    protected void deleteInstance(WebCmsEndpoint instance, WebCmsDataEntry data) {
        this.endpointRepository.delete(instance);
    }

    @Override
    protected void saveDto(WebCmsEndpoint dto, WebCmsDataAction action, WebCmsDataEntry data) {
        this.endpointRepository.save(dto);
    }

    public WebCmsRemoteEndpointImporter(WebCmsRemoteEndpointRepository remoteEndpointRepository, WebCmsEndpointRepository endpointRepository) {
        this.remoteEndpointRepository = remoteEndpointRepository;
        this.endpointRepository = endpointRepository;
    }
}

