/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.redirect.config;

import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.EntityAttributes;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.config.builders.EntitiesConfigurationBuilder;
import com.foreach.across.modules.entity.registry.EntityAssociation;
import com.foreach.across.modules.entity.registry.EntityConfiguration;
import com.foreach.across.modules.entity.registry.EntityRegistry;
import com.foreach.across.modules.entity.registry.properties.EntityPropertySelector;
import com.foreach.across.modules.entity.support.EntityMessageCodeResolver;
import com.foreach.across.modules.entity.util.EntityUtils;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.EntityViewElementBuilderHelper;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.ViewElementMode;
import com.foreach.across.modules.entity.views.bootstrapui.processors.element.EntityListActionsProcessor;
import com.foreach.across.modules.entity.views.bootstrapui.util.SortableTableBuilder;
import com.foreach.across.modules.entity.views.context.EntityViewContext;
import com.foreach.across.modules.entity.views.menu.EntityAdminMenuEvent;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.processors.SimpleEntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.views.support.EntityMessages;
import com.foreach.across.modules.entity.web.links.EntityViewLinkBuilder;
import com.foreach.across.modules.web.ui.DefaultViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.ViewElementPostProcessor;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.TextViewElement;
import com.foreach.across.modules.web.ui.elements.builder.NodeViewElementBuilder;
import com.foreach.across.modules.web.ui.elements.support.ContainerViewElementUtils;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.redirect.WebCmsRemoteEndpoint;
import com.foreach.across.modules.webcms.domain.redirect.web.WebCmsRemoteEndpointViewElementBuilder;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import org.springframework.context.event.EventListener;
import org.springframework.format.Printer;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@ConditionalOnAdminUI
@Component
class WebCmsRemoteEndpointConfiguration
implements EntityConfigurer {
    private final RemoteEndpointLabelPrinter remoteEndpointLabelPrinter;
    private final UrlsControlViewElementBuilder urlsControlViewElementBuilder;
    private final WebCmsRemoteEndpointViewElementBuilder remoteEndpointViewElementBuilder;

    @EventListener
    void hideUrlsTab(EntityAdminMenuEvent<WebCmsRemoteEndpoint> menu) {
        menu.builder().item("webCmsRemoteEndpoint.urls").disable();
    }

    public void configure(EntitiesConfigurationBuilder entities) {
        entities.withType(WebCmsRemoteEndpoint.class).attribute("endpointValueBuilder", (Object)this.remoteEndpointViewElementBuilder).entityModel(model -> model.labelPrinter((Printer)this.remoteEndpointLabelPrinter)).properties(props -> props.property("targetUrl").viewElementPostProcessor(ViewElementMode.CONTROL, (ctx, textbox) -> textbox.setRows(1)).and().property("urls").viewElementBuilder(ViewElementMode.FORM_WRITE, (ViewElementBuilder)this.urlsControlViewElementBuilder)).listView(lvb -> lvb.showProperties(new String[]{"targetUrl"}).defaultSort("targetUrl")).createFormView(fvb -> fvb.showProperties(new String[]{"targetUrl"})).updateFormView(fvb -> fvb.showProperties(new String[]{"targetUrl", "urls"}).viewProcessor((EntityViewProcessor)new UpdateRedirectFormProcessor())).association(ab -> ab.name("webCmsRemoteEndpoint.urls").associationType(EntityAssociation.Type.EMBEDDED).parentDeleteMode(EntityAssociation.ParentDeleteMode.IGNORE).createOrUpdateFormView(fvb -> fvb.showProperties(new String[]{"path", "httpStatus"}).properties(props -> props.property("httpStatus").attribute(EntityAttributes.OPTIONS_ALLOWED_VALUES, EnumSet.of(HttpStatus.FOUND, HttpStatus.MOVED_PERMANENTLY)))).createFormView(fvb -> fvb.viewProcessor((EntityViewProcessor)new CreateUrlFormProcessor())).updateFormView(fvb -> fvb.viewProcessor((EntityViewProcessor)new UpdateUrlFormProcessor())).listView(lvb -> lvb.viewProcessor((EntityViewProcessor)new ListUrlFormProcessor())));
    }

    public WebCmsRemoteEndpointConfiguration(RemoteEndpointLabelPrinter remoteEndpointLabelPrinter, UrlsControlViewElementBuilder urlsControlViewElementBuilder, WebCmsRemoteEndpointViewElementBuilder remoteEndpointViewElementBuilder) {
        this.remoteEndpointLabelPrinter = remoteEndpointLabelPrinter;
        this.urlsControlViewElementBuilder = urlsControlViewElementBuilder;
        this.remoteEndpointViewElementBuilder = remoteEndpointViewElementBuilder;
    }

    private static class UpdateUrlFormProcessor
    extends EntityViewProcessorAdapter {
        private UpdateUrlFormProcessor() {
        }

        protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
            String message = entityViewRequest.getEntityViewContext().getMessageCodeResolver().getMessage("bodyTitle.update", "Update redirect path");
            container.addFirstChild((ViewElement)((NodeViewElementBuilder)new NodeViewElementBuilder("h4").add(new ViewElement[]{TextViewElement.html((String)message)})).build(builderContext));
        }
    }

    private static class CreateUrlFormProcessor
    extends EntityViewProcessorAdapter {
        private CreateUrlFormProcessor() {
        }

        protected void doGet(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command) {
            ((WebCmsUrl)((Object)command.getEntity(WebCmsUrl.class))).setHttpStatus(HttpStatus.MOVED_PERMANENTLY);
        }

        protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
            String message = entityViewRequest.getEntityViewContext().getMessageCodeResolver().getMessage("bodyTitle.create", "Add a path to redirect");
            container.addFirstChild((ViewElement)((NodeViewElementBuilder)new NodeViewElementBuilder("h4").add(new ViewElement[]{TextViewElement.html((String)message)})).build(builderContext));
        }
    }

    private static class ListUrlFormProcessor
    extends SimpleEntityViewProcessorAdapter {
        private ListUrlFormProcessor() {
        }

        public void doControl(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command) {
            EntityViewContext endpointContext = entityViewRequest.getEntityViewContext().getParentContext();
            entityView.setRedirectUrl(endpointContext.getLinkBuilder().forInstance(endpointContext.getEntity()).updateView().toUriString());
        }
    }

    @ConditionalOnAdminUI
    @Component
    private static class UpdateRedirectFormProcessor
    extends EntityViewProcessorAdapter {
        protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
            ContainerViewElementUtils.move((ContainerViewElement)container, (String)"buttons", (String)"entityForm-column-0");
            ContainerViewElementUtils.move((ContainerViewElement)container, (String)"formGroup-urls", (String)"entityForm-column-1");
        }
    }

    @ConditionalOnAdminUI
    @Component
    private static class UrlsControlViewElementBuilder
    implements ViewElementBuilder<ContainerViewElement> {
        private final EntityViewElementBuilderHelper builderHelper;

        public ContainerViewElement build(ViewElementBuilderContext builderContext) {
            EntityViewRequest entityViewRequest = (EntityViewRequest)builderContext.getAttribute(EntityViewRequest.class);
            EntityViewContext entityViewContext = entityViewRequest.getEntityViewContext();
            WebCmsRemoteEndpoint endpoint = (WebCmsRemoteEndpoint)entityViewRequest.getCommand().getEntity(WebCmsRemoteEndpoint.class);
            EntityAssociation association = entityViewContext.getEntityConfiguration().association("webCmsRemoteEndpoint.urls");
            EntityMessageCodeResolver codeResolver = (EntityMessageCodeResolver)association.getAttribute(EntityMessageCodeResolver.class);
            SortableTableBuilder tableBuilder = this.builderHelper.createSortableTableBuilder(WebCmsUrl.class);
            tableBuilder.properties(EntityPropertySelector.of((String[])new String[]{"path", "httpStatus"}));
            tableBuilder.noSorting();
            tableBuilder.tableName("urls");
            ArrayList<WebCmsUrl> urls = new ArrayList<WebCmsUrl>(endpoint.getUrls());
            urls.sort(Comparator.comparing(WebCmsUrl::getPath));
            tableBuilder.items(EntityUtils.asPage(urls));
            tableBuilder.tableOnly();
            tableBuilder.hideResultNumber();
            tableBuilder.noResults((ViewElementBuilder)HtmlViewElements.html.builders.container());
            EntityViewLinkBuilder associationLinkBuilder = entityViewContext.getLinkBuilder().forInstance(entityViewContext.getEntity()).association("webCmsRemoteEndpoint.urls");
            EntityListActionsProcessor actionsProcessor = new EntityListActionsProcessor(association.getTargetEntityConfiguration(), associationLinkBuilder, new EntityMessages(codeResolver));
            tableBuilder.headerRowProcessor((ViewElementPostProcessor)actionsProcessor);
            tableBuilder.valueRowProcessor((ViewElementPostProcessor)actionsProcessor);
            String message = entityViewContext.getMessageCodeResolver().getMessage("properties.urls.add", "Add a path to redirect");
            return (ContainerViewElement)((NodeViewElementBuilder)((NodeViewElementBuilder)((NodeViewElementBuilder)HtmlViewElements.html.builders.div().name("formGroup-urls")).add(new ViewElementBuilder[]{tableBuilder})).add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.button().link(associationLinkBuilder.createView().toUriString()).style(Style.PRIMARY).text(message)})).build((ViewElementBuilderContext)new DefaultViewElementBuilderContext());
        }

        public UrlsControlViewElementBuilder(EntityViewElementBuilderHelper builderHelper) {
            this.builderHelper = builderHelper;
        }
    }

    @ConditionalOnAdminUI
    @Component
    private static class RemoteEndpointLabelPrinter
    implements Printer<WebCmsRemoteEndpoint> {
        private final EntityRegistry entityRegistry;

        public String print(WebCmsRemoteEndpoint endpoint, Locale locale) {
            EntityConfiguration entityConfiguration = this.entityRegistry.getEntityConfiguration(WebCmsRemoteEndpoint.class);
            String name = entityConfiguration.getEntityMessageCodeResolver().getNameSingular(locale);
            return name + ": " + endpoint.getTargetUrl();
        }

        public RemoteEndpointLabelPrinter(EntityRegistry entityRegistry) {
            this.entityRegistry = entityRegistry;
        }
    }
}

