/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierRepository;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierService;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.stereotype.Component;

@Component
public class MapToWebCmsTypeSpecifierConverter
implements ConverterFactory<Map<String, Object>, WebCmsTypeSpecifier> {
    private final WebCmsDataConversionService conversionService;
    private final WebCmsTypeSpecifierService typeSpecifierService;
    private final WebCmsTypeSpecifierRepository typeSpecifierRepository;

    @PostConstruct
    void registerToConversionService() {
        this.conversionService.addConverterFactory(this);
    }

    public <T extends WebCmsTypeSpecifier> Converter<Map<String, Object>, T> getConverter(Class<T> targetType) {
        return data -> {
            if (data.containsKey("objectId")) {
                return (WebCmsTypeSpecifier)targetType.cast(this.typeSpecifierRepository.findOneByObjectId(Objects.toString(data.get("objectId"))));
            }
            if (data.containsKey("typeKey")) {
                String typeKey = Objects.toString(data.get("typeKey"));
                if (data.containsKey("domain")) {
                    return this.typeSpecifierService.getTypeSpecifierByKey(typeKey, targetType, (WebCmsDomain)this.conversionService.convert(data.get("domain"), WebCmsDomain.class));
                }
                return this.typeSpecifierService.getTypeSpecifierByKey(typeKey, targetType);
            }
            return null;
        };
    }

    public MapToWebCmsTypeSpecifierConverter(WebCmsDataConversionService conversionService, WebCmsTypeSpecifierService typeSpecifierService, WebCmsTypeSpecifierRepository typeSpecifierRepository) {
        this.conversionService = conversionService;
        this.typeSpecifierService = typeSpecifierService;
        this.typeSpecifierRepository = typeSpecifierRepository;
    }
}

