/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierRepository;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.stereotype.Component;

@Component
public class StringToWebCmsTypeSpecifierConverter
implements ConverterFactory<String, WebCmsTypeSpecifier> {
    private final WebCmsTypeSpecifierRepository typeSpecifierRepository;
    private final WebCmsTypeSpecifierService typeSpecifierService;

    @Autowired
    public void registerToConversionService(WebCmsDataConversionService conversionService) {
        conversionService.addConverterFactory(this);
    }

    public <T extends WebCmsTypeSpecifier> Converter<String, T> getConverter(Class<T> targetType) {
        return id -> {
            WebCmsTypeSpecifier type = this.typeSpecifierRepository.findOneByObjectId((String)id).orElse(null);
            if (type == null) {
                return this.typeSpecifierService.getTypeSpecifierByKey((String)id, targetType);
            }
            return (WebCmsTypeSpecifier)targetType.cast(type);
        };
    }

    public StringToWebCmsTypeSpecifierConverter(WebCmsTypeSpecifierRepository typeSpecifierRepository, WebCmsTypeSpecifierService typeSpecifierService) {
        this.typeSpecifierRepository = typeSpecifierRepository;
        this.typeSpecifierService = typeSpecifierService;
    }
}

