/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.component.WebCmsComponent;
import com.foreach.across.modules.webcms.domain.component.WebCmsContentMarkerService;
import com.foreach.across.modules.webcms.domain.component.container.ContainerWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.component.model.WebCmsComponentModelService;
import com.foreach.across.modules.webcms.domain.component.text.TextWebCmsComponentModel;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomainBound;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.type.WebCmsDefaultComponentsService;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
final class WebCmsDefaultComponentsServiceImpl
implements WebCmsDefaultComponentsService {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsDefaultComponentsServiceImpl.class);
    private static final String DEFAULT_CONTENT_TEMPLATE_COMPONENT = "contentTemplate";
    private final WebCmsComponentModelService componentModelService;
    private final WebCmsContentMarkerService contentMarkerService;
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsTypeSpecifierService typeSpecifierService;

    @Override
    public void createDefaultComponents(WebCmsAsset<?> asset, Map<String, String> markerValues) {
        this.createDefaultComponents(asset, asset.getAssetType(), markerValues);
    }

    @Override
    public void createDefaultComponents(WebCmsObject asset, WebCmsTypeSpecifier<?> typeSpecifier, Map<String, String> markerValues) {
        WebCmsComponentModel template;
        if (typeSpecifier != null && (template = this.retrieveContentTemplate(typeSpecifier)) != null) {
            if (template instanceof ContainerWebCmsComponentModel) {
                LOG.trace("Copying members of contentTemplate {} to {}", (Object)template, (Object)asset);
                ContainerWebCmsComponentModel container = (ContainerWebCmsComponentModel)template;
                List<WebCmsComponentModel> members = container.getMembers();
                members.forEach(m -> {
                    WebCmsComponentModel clone = m.asComponentTemplate();
                    clone.setOwner(asset);
                    if (asset instanceof WebCmsDomainBound) {
                        clone.setDomain(((WebCmsDomainBound)((Object)asset)).getDomain());
                    }
                    this.replaceAttributesInTextComponents(clone, markerValues);
                    this.componentModelService.save(clone);
                });
            } else {
                LOG.warn("A contentTemplate was found but was not of type ContainerWebCmsComponentModel. Only container models are supported as the members of the container will be copied to the asset.Ignoring the content template.");
            }
        }
    }

    private void replaceAttributesInTextComponents(WebCmsComponentModel componentModel, Map<String, String> markerValues) {
        if (componentModel instanceof TextWebCmsComponentModel) {
            TextWebCmsComponentModel text = (TextWebCmsComponentModel)componentModel;
            text.setContent(this.contentMarkerService.replaceMarkers(text.getContent(), markerValues));
        } else if (componentModel instanceof ContainerWebCmsComponentModel) {
            ContainerWebCmsComponentModel container = (ContainerWebCmsComponentModel)componentModel;
            if (container.hasMarkup()) {
                container.setMarkup(this.contentMarkerService.replaceMarkers(container.getMarkup(), markerValues));
            }
            container.getMembers().forEach(m -> this.replaceAttributesInTextComponents((WebCmsComponentModel)m, markerValues));
        }
    }

    private WebCmsComponentModel retrieveContentTemplate(WebCmsTypeSpecifier<?> cmsTypeSpecifier) {
        Object parentCmsType;
        String contentTemplateName = StringUtils.defaultString((String)cmsTypeSpecifier.getAttribute(DEFAULT_CONTENT_TEMPLATE_COMPONENT), (String)DEFAULT_CONTENT_TEMPLATE_COMPONENT);
        WebCmsDomain currentDomain = this.multiDomainService.getCurrentDomainForType(WebCmsComponent.class);
        WebCmsDomain typeDomain = cmsTypeSpecifier.getDomain();
        WebCmsComponentModel template = this.componentModelService.getComponentModelByNameAndDomain(contentTemplateName, cmsTypeSpecifier, currentDomain);
        if (template == null && !Objects.equals(currentDomain, typeDomain)) {
            template = this.componentModelService.getComponentModelByNameAndDomain(contentTemplateName, cmsTypeSpecifier, typeDomain);
        }
        if (template == null && cmsTypeSpecifier.hasAttribute("parent") && (parentCmsType = this.typeSpecifierService.getTypeSpecifierByKey(cmsTypeSpecifier.getAttribute("parent"), cmsTypeSpecifier.getClass())) != null) {
            return this.retrieveContentTemplate((WebCmsTypeSpecifier<?>)parentCmsType);
        }
        return template;
    }

    public WebCmsDefaultComponentsServiceImpl(WebCmsComponentModelService componentModelService, WebCmsContentMarkerService contentMarkerService, WebCmsMultiDomainService multiDomainService, WebCmsTypeSpecifierService typeSpecifierService) {
        this.componentModelService = componentModelService;
        this.contentMarkerService = contentMarkerService;
        this.multiDomainService = multiDomainService;
        this.typeSpecifierService = typeSpecifierService;
    }
}

