/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataConversionService;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLink;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLinkRepository;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class WebCmsTypeLinkPropertyDataImporter
implements WebCmsPropertyDataImporter<WebCmsObject> {
    public static final String PROPERTY_NAME = "wcm:types";
    private final WebCmsDataConversionService conversionService;
    private final WebCmsTypeSpecifierLinkRepository typeLinkRepository;

    @Override
    public boolean supports(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return WebCmsPropertyDataImporter.Phase.AFTER_ASSET_SAVED.equals((Object)phase) && PROPERTY_NAME.equals(dataEntry.getParentKey()) && asset instanceof WebCmsObject;
    }

    @Override
    public boolean importData(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry propertyData, WebCmsObject asset, WebCmsDataAction action) {
        WebCmsTypeSpecifierLink typeLink = new WebCmsTypeSpecifierLink();
        this.conversionService.convertToPropertyValues(propertyData.getMapData(), (Object)typeLink);
        typeLink.setOwner(asset);
        Optional<WebCmsTypeSpecifierLink> existing = this.typeLinkRepository.findOneByOwnerObjectIdAndLinkTypeAndTypeSpecifier(typeLink.getOwnerObjectId(), typeLink.getLinkType(), typeLink.getTypeSpecifier());
        if (!existing.isPresent()) {
            this.typeLinkRepository.save((Object)typeLink);
        }
        return true;
    }

    public WebCmsTypeLinkPropertyDataImporter(WebCmsDataConversionService conversionService, WebCmsTypeSpecifierLinkRepository typeLinkRepository) {
        this.conversionService = conversionService;
        this.typeLinkRepository = typeLinkRepository;
    }
}

