/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public final class WebCmsTypeRegistry {
    private final Map<String, Class<? extends WebCmsTypeSpecifier>> typesForGroup = new HashMap<String, Class<? extends WebCmsTypeSpecifier>>();
    private final Map<String, String> groupsForType = new HashMap<String, String>();
    private final Map<String, Supplier> suppliersForImplementationType = new HashMap<String, Supplier>();

    public <U extends WebCmsTypeSpecifier> void register(@NonNull String objectType, @NonNull Class<U> implementationType, @NonNull Supplier<U> supplier) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        if (implementationType == null) {
            throw new NullPointerException("implementationType is marked non-null but is null");
        }
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        this.typesForGroup.put(objectType, implementationType);
        this.suppliersForImplementationType.put(implementationType.getName(), supplier);
        this.groupsForType.put(implementationType.getName(), objectType);
    }

    public Optional<Class<? extends WebCmsTypeSpecifier>> retrieveTypeSpecifierClass(@NonNull String objectType) {
        if (objectType == null) {
            throw new NullPointerException("objectType is marked non-null but is null");
        }
        return Optional.ofNullable(this.typesForGroup.get(objectType));
    }

    public <U extends WebCmsTypeSpecifier> Optional<Supplier<U>> retrieveSupplier(@NonNull Class<U> implementationType) {
        if (implementationType == null) {
            throw new NullPointerException("implementationType is marked non-null but is null");
        }
        return Optional.ofNullable(this.suppliersForImplementationType.get(implementationType.getName()));
    }

    public <U extends WebCmsTypeSpecifier> Optional<String> retrieveObjectType(@NonNull Class<U> implementationType) {
        if (implementationType == null) {
            throw new NullPointerException("implementationType is marked non-null but is null");
        }
        return Optional.ofNullable(this.groupsForType.get(implementationType.getName()));
    }
}

