/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.domain.WebCmsChildComponentRestrictable;
import com.foreach.across.modules.webcms.domain.WebCmsObjectInheritanceSuperClass;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SortNatural;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="wcm_type")
@Access(value=AccessType.FIELD)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="object_type", discriminatorType=DiscriminatorType.STRING)
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@NotThreadSafe
public abstract class WebCmsTypeSpecifier<T extends WebCmsTypeSpecifier<T>>
extends WebCmsObjectInheritanceSuperClass<T>
implements WebCmsChildComponentRestrictable {
    @Id
    @GeneratedValue(generator="seq_wcm_type_id")
    @GenericGenerator(name="seq_wcm_type_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_type_id"), @Parameter(name="allocationSize", value="1")})
    private Long id;
    @Column(name="name")
    @NotBlank
    @Length(max=255)
    private @NotBlank @Length(max=255) String name;
    @Column(name="type_key")
    @NotBlank
    @Length(max=255)
    @Pattern(regexp="[^\\s]*")
    private @NotBlank @Length(max=255) @Pattern(regexp="[^\\s]*") String typeKey;
    @Column(name="description")
    @Length(max=500)
    private @Length(max=500) String description;
    @ElementCollection(fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL})
    @CollectionTable(name="wcm_type_attributes", joinColumns={@JoinColumn(name="type_id")})
    @MapKeyColumn(name="attribute_key")
    @Column(name="attribute_value")
    @SortNatural
    private SortedMap<String, String> attributes = new TreeMap<String, String>();

    protected WebCmsTypeSpecifier(Long id, Long newEntityId, String objectId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, WebCmsDomain domain, String name, String typeKey, String description, Map<String, String> attributes) {
        super(id, newEntityId, objectId, createdBy, createdDate, lastModifiedBy, lastModifiedDate, domain);
        this.name = name;
        this.description = description;
        this.attributes = new TreeMap<String, String>(attributes);
        this.typeKey = typeKey;
    }

    public final String getAttribute(String attributeKey) {
        return (String)this.getAttributes().get(attributeKey);
    }

    public final String getAttribute(String attributeKey, String defaultValue) {
        return this.getAttributes().getOrDefault(attributeKey, defaultValue);
    }

    protected final boolean getBooleanAttribute(String attributeKey, boolean defaultValue) {
        String action = (String)this.getAttributes().get(attributeKey);
        if (StringUtils.isEmpty((CharSequence)action)) {
            return defaultValue;
        }
        return BooleanUtils.toBoolean((String)action);
    }

    public boolean hasAttribute(String attributeKey) {
        return this.getAttributes().containsKey(attributeKey);
    }

    @Override
    public boolean isChildComponentRestricted() {
        return this.getBooleanAttribute("childComponentsRestricted", false);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{objectId='" + this.getObjectId() + '\'' + ", typeKey='" + this.typeKey + '\'' + '}';
    }

    public WebCmsTypeSpecifier() {
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeKey() {
        return this.typeKey;
    }

    public String getDescription() {
        return this.description;
    }

    public SortedMap<String, String> getAttributes() {
        return this.attributes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAttributes(SortedMap<String, String> attributes) {
        this.attributes = attributes;
    }
}

