/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.data.AbstractWebCmsDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeRegistry;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierRepository;
import com.foreach.across.modules.webcms.domain.type.web.WebCmsTypeSpecifierValidator;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
final class WebCmsTypeSpecifierImporter
extends AbstractWebCmsDataImporter<WebCmsTypeSpecifier<?>, WebCmsTypeSpecifier<?>> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsTypeSpecifierImporter.class);
    private final WebCmsTypeRegistry typeRegistry;
    private final WebCmsTypeSpecifierRepository typeRepository;
    private final WebCmsTypeSpecifierValidator typeValidator;

    @Override
    public boolean supports(WebCmsDataEntry data) {
        return data.getParent() != null && "types".equals(data.getParent().getParentKey());
    }

    @Override
    protected WebCmsTypeSpecifier retrieveExistingInstance(WebCmsDataEntry data) {
        String typeGroup = StringUtils.defaultString((String)data.getParentKey(), (String)((String)data.getMapData().get("typeGroup")));
        String typeKey = data.getKey();
        String objectId = (String)data.getMapData().get("objectId");
        WebCmsTypeSpecifier existing = null;
        if (objectId != null) {
            existing = this.typeRepository.findOneByObjectId(objectId).orElse(null);
        }
        WebCmsDomain domain = this.retrieveDomainForDataEntry(data, WebCmsTypeSpecifier.class);
        return existing != null ? existing : (WebCmsTypeSpecifier)this.typeRepository.findOneByObjectTypeAndTypeKeyAndDomain(typeGroup, typeKey, domain).orElse(null);
    }

    @Override
    protected WebCmsTypeSpecifier createDto(WebCmsDataEntry data, WebCmsTypeSpecifier<?> existing, WebCmsDataAction action, Map<String, Object> dataValues) {
        String typeGroup = StringUtils.defaultString((String)data.getParentKey(), (String)((String)data.getMapData().get("typeGroup")));
        Class<? extends WebCmsTypeSpecifier> implementationType = this.typeRegistry.retrieveTypeSpecifierClass(typeGroup).orElseThrow(() -> new IllegalArgumentException("Unable to import type: " + typeGroup));
        if (existing != null && action != WebCmsDataAction.REPLACE) {
            return (WebCmsTypeSpecifier)existing.toDto();
        }
        Supplier<? extends WebCmsTypeSpecifier> supplier = this.typeRegistry.retrieveSupplier(implementationType).orElseThrow(() -> new IllegalStateException("No valid supplier was registered for: " + implementationType));
        if (existing != null) {
            WebCmsTypeSpecifier type = supplier.get();
            type.setId(existing.getId());
            type.setCreatedBy(existing.getCreatedBy());
            type.setCreatedDate(existing.getCreatedDate());
            return type;
        }
        return supplier.get();
    }

    @Override
    protected void deleteInstance(WebCmsTypeSpecifier instance, WebCmsDataEntry data) {
        this.typeRepository.delete(instance);
    }

    @Override
    protected WebCmsTypeSpecifier<?> prepareForSaving(WebCmsTypeSpecifier<?> dto, WebCmsDataEntry data) {
        if (dto.isNew() && dto.getTypeKey() == null) {
            dto.setTypeKey(data.getKey());
        }
        return dto;
    }

    @Override
    protected void validate(WebCmsTypeSpecifier<?> dto, Errors errors) {
        this.typeValidator.validate(dto, errors);
    }

    @Override
    protected void saveDto(WebCmsTypeSpecifier dto, WebCmsDataAction action, WebCmsDataEntry data) {
        LOG.debug("Saving WebCmsTypeSpecifier {} with objectId {} (insert: {}) - {}", new Object[]{dto.getClass().getSimpleName(), dto.getObjectId(), dto.isNew(), dto});
        this.typeRepository.save(dto);
    }

    public WebCmsTypeSpecifierImporter(WebCmsTypeRegistry typeRegistry, WebCmsTypeSpecifierRepository typeRepository, WebCmsTypeSpecifierValidator typeValidator) {
        this.typeRegistry = typeRegistry;
        this.typeRepository = typeRepository;
        this.typeValidator = typeValidator;
    }
}

