/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.hibernate.business.SettableIdAuditableEntity;
import com.foreach.across.modules.webcms.domain.WebCmsObject;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import java.util.Date;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="wcm_object_type_link")
@Access(value=AccessType.FIELD)
@NotThreadSafe
public class WebCmsTypeSpecifierLink
extends SettableIdAuditableEntity<WebCmsTypeSpecifierLink> {
    @Id
    @GeneratedValue(generator="seq_wcm_object_type_link_id")
    @GenericGenerator(name="seq_wcm_object_type_link_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_object_type_link_id"), @Parameter(name="allocationSize", value="1")})
    private Long id;
    @Column(name="owner_object_id")
    @Length(max=100)
    private @Length(max=100) String ownerObjectId;
    @NotNull
    @ManyToOne
    @JoinColumn(name="type_id")
    private WebCmsTypeSpecifier typeSpecifier;
    @Column(name="link_type")
    @Length(max=255)
    @Length(max=255) String linkType;
    @Column(name="sort_index")
    private int sortIndex;

    public WebCmsTypeSpecifierLink() {
    }

    protected WebCmsTypeSpecifierLink(Long id, Long newEntityId, String createdBy, Date createdDate, String lastModifiedBy, Date lastModifiedDate, String ownerObjectId, WebCmsTypeSpecifier typeSpecifier, String linkType, int sortIndex) {
        this.setId(id);
        this.setNewEntityId(newEntityId);
        this.setCreatedBy(createdBy);
        this.setCreatedDate(createdDate);
        this.setLastModifiedBy(lastModifiedBy);
        this.setLastModifiedDate(lastModifiedDate);
        this.setOwnerObjectId(ownerObjectId);
        this.setTypeSpecifier(typeSpecifier);
        this.setLinkType(linkType);
        this.setSortIndex(sortIndex);
    }

    public void setOwner(WebCmsObject owner) {
        this.setOwnerObjectId(owner != null ? owner.getObjectId() : null);
    }

    public <U extends WebCmsTypeSpecifier<U>> U getTypeSpecifier(Class<U> specifierType) {
        return (U)((WebCmsTypeSpecifier)specifierType.cast(this.getTypeSpecifier()));
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{ownerObjectId='" + this.ownerObjectId + '\'' + ", typeSpecifier=" + this.typeSpecifier + ", linkType='" + this.linkType + '\'' + '}';
    }

    public Long getId() {
        return this.id;
    }

    public String getOwnerObjectId() {
        return this.ownerObjectId;
    }

    public WebCmsTypeSpecifier getTypeSpecifier() {
        return this.typeSpecifier;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOwnerObjectId(String ownerObjectId) {
        this.ownerObjectId = ownerObjectId;
    }

    public void setTypeSpecifier(WebCmsTypeSpecifier typeSpecifier) {
        this.typeSpecifier = typeSpecifier;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }
}

