/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type;

import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeRegistry;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierRepository;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierService;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
class WebCmsTypeSpecifierServiceImpl
implements WebCmsTypeSpecifierService {
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsTypeRegistry typeRegistry;
    private final WebCmsTypeSpecifierRepository typeSpecifierRepository;

    @Override
    public <T extends WebCmsTypeSpecifier> T getTypeSpecifier(String objectId, Class<T> expectedType) {
        Assert.notNull(expectedType, (String)"Expected type is required");
        WebCmsTypeSpecifier<?> typeSpecifier = this.getTypeSpecifier(objectId);
        if (typeSpecifier != null && !expectedType.isInstance(typeSpecifier)) {
            throw new IllegalArgumentException("Object with objectId " + objectId + " exists but is not of type " + expectedType.getName());
        }
        return (T)((WebCmsTypeSpecifier)expectedType.cast(typeSpecifier));
    }

    @Override
    public WebCmsTypeSpecifier<?> getTypeSpecifier(String objectId) {
        return this.typeSpecifierRepository.findOneByObjectId(objectId).orElse(null);
    }

    @Override
    public <T extends WebCmsTypeSpecifier> T getTypeSpecifierByKey(String typeKey, Class<T> expectedType) {
        return this.getTypeSpecifierByKey(typeKey, expectedType, this.multiDomainService.getCurrentDomainForType(expectedType));
    }

    @Override
    public <T extends WebCmsTypeSpecifier> T getTypeSpecifierByKey(String typeKey, Class<T> expectedType, WebCmsDomain domain) {
        String objectType = this.typeRegistry.retrieveObjectType(expectedType).orElseThrow(() -> new IllegalArgumentException("Unknown WebCmsTypeSpecifier: " + expectedType + ", must be registered in the WebCmsTypeRegistry"));
        WebCmsTypeSpecifier candidate = this.typeSpecifierRepository.findOneByObjectTypeAndTypeKeyAndDomain(objectType, typeKey, domain).orElse(null);
        if (candidate == null && !WebCmsDomain.isNoDomain(domain) && this.multiDomainService.isNoDomainAllowed(expectedType)) {
            candidate = this.typeSpecifierRepository.findOneByObjectTypeAndTypeKeyAndDomain(objectType, typeKey, WebCmsDomain.NONE).orElse(null);
        }
        return (T)((WebCmsTypeSpecifier)expectedType.cast(candidate));
    }

    public WebCmsTypeSpecifierServiceImpl(WebCmsMultiDomainService multiDomainService, WebCmsTypeRegistry typeRegistry, WebCmsTypeSpecifierRepository typeSpecifierRepository) {
        this.multiDomainService = multiDomainService;
        this.typeRegistry = typeRegistry;
        this.typeSpecifierRepository = typeSpecifierRepository;
    }
}

