/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.type.web;

import com.foreach.across.modules.entity.views.events.BuildEntityDeleteViewEvent;
import com.foreach.across.modules.web.ui.ViewElement;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.builder.NodeViewElementBuilder;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.type.QWebCmsTypeSpecifierLink;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifier;
import com.foreach.across.modules.webcms.domain.type.WebCmsTypeSpecifierLinkRepository;
import com.querydsl.core.types.Predicate;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@ConditionalOnAdminUI
@Component
class TypeLinkDeleteViewEventHandler {
    private final WebCmsTypeSpecifierLinkRepository linkRepository;

    @EventListener
    void handleTypeBeingDeleted(BuildEntityDeleteViewEvent<WebCmsTypeSpecifier> deleteViewEvent) {
        QWebCmsTypeSpecifierLink query = QWebCmsTypeSpecifierLink.webCmsTypeSpecifierLink;
        long nonSelfLinks = this.linkRepository.count((Predicate)query.typeSpecifier.eq(deleteViewEvent.getEntity()).and((Predicate)query.ownerObjectId.ne((Object)((WebCmsTypeSpecifier)deleteViewEvent.getEntity()).getObjectId())));
        if (nonSelfLinks > 0L) {
            ViewElementBuilderContext builderContext = deleteViewEvent.getBuilderContext();
            deleteViewEvent.setDeleteDisabled(true);
            deleteViewEvent.associations().addChild((ViewElement)((NodeViewElementBuilder)HtmlViewElements.html.builders.li().add(new ViewElement[]{HtmlViewElements.html.unescapedText(builderContext.getMessage("objectsLinkedToTypeSpecifier", new Object[]{nonSelfLinks}))})).build(builderContext));
        }
    }

    public TypeLinkDeleteViewEventHandler(WebCmsTypeSpecifierLinkRepository linkRepository) {
        this.linkRepository = linkRepository;
    }
}

