/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url;

import com.foreach.across.modules.hibernate.business.SettableIdBasedEntity;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import javax.annotation.concurrent.NotThreadSafe;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;
import org.springframework.http.HttpStatus;

@Entity
@Table(name="wcm_url")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
@NotThreadSafe
public class WebCmsUrl
extends SettableIdBasedEntity<WebCmsUrl> {
    @Id
    @GeneratedValue(generator="seq_wcm_url_id")
    @GenericGenerator(name="seq_wcm_url_id", strategy="com.foreach.across.modules.hibernate.id.AcrossSequenceGenerator", parameters={@Parameter(name="sequenceName", value="seq_wcm_url_id"), @Parameter(name="allocationSize", value="10")})
    private Long id;
    @NotBlank
    @Length(max=255)
    @Column(unique=true)
    private @NotBlank @Length(max=255) String path;
    @NotNull
    @Type(type="com.foreach.across.modules.webcms.domain.url.HttpStatusType")
    @Column(name="http_status")
    private HttpStatus httpStatus;
    @NotNull
    @ManyToOne
    @JoinColumn(name="endpoint_id")
    private WebCmsEndpoint endpoint;
    @NotNull
    @Column(name="is_primary")
    private boolean primary;
    @NotNull
    @Column(name="is_primary_locked")
    private boolean primaryLocked;

    public void setPath(String path) {
        if (!StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    public static WebCmsUrlBuilder builder() {
        return new WebCmsUrlBuilder();
    }

    public WebCmsUrlBuilder toBuilder() {
        return new WebCmsUrlBuilder().id(this.id).path(this.path).httpStatus(this.httpStatus).endpoint(this.endpoint).primary(this.primary).primaryLocked(this.primaryLocked);
    }

    public WebCmsUrl() {
    }

    private WebCmsUrl(Long id, String path, HttpStatus httpStatus, WebCmsEndpoint endpoint, boolean primary, boolean primaryLocked) {
        this.id = id;
        this.path = path;
        this.httpStatus = httpStatus;
        this.endpoint = endpoint;
        this.primary = primary;
        this.primaryLocked = primaryLocked;
    }

    public Long getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public WebCmsEndpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public boolean isPrimaryLocked() {
        return this.primaryLocked;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    public void setEndpoint(WebCmsEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setPrimaryLocked(boolean primaryLocked) {
        this.primaryLocked = primaryLocked;
    }

    public static class WebCmsUrlBuilder {
        private Long id;
        private HttpStatus httpStatus;
        private WebCmsEndpoint endpoint;
        private boolean primary;
        private boolean primaryLocked;
        private String path;

        public WebCmsUrlBuilder path(String path) {
            if (!StringUtils.startsWith((CharSequence)path, (CharSequence)"/")) {
                path = "/" + path;
            }
            this.path = path;
            return this;
        }

        WebCmsUrlBuilder() {
        }

        public WebCmsUrlBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public WebCmsUrlBuilder httpStatus(HttpStatus httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public WebCmsUrlBuilder endpoint(WebCmsEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public WebCmsUrlBuilder primary(boolean primary) {
            this.primary = primary;
            return this;
        }

        public WebCmsUrlBuilder primaryLocked(boolean primaryLocked) {
            this.primaryLocked = primaryLocked;
            return this;
        }

        public WebCmsUrl build() {
            return new WebCmsUrl(this.id, this.path, this.httpStatus, this.endpoint, this.primary, this.primaryLocked);
        }

        public String toString() {
            return "WebCmsUrl.WebCmsUrlBuilder(id=" + this.id + ", path=" + this.path + ", httpStatus=" + this.httpStatus + ", endpoint=" + this.endpoint + ", primary=" + this.primary + ", primaryLocked=" + this.primaryLocked + ")";
        }
    }
}

