/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url;

import com.foreach.across.core.annotations.PostRefresh;
import com.foreach.across.modules.webcms.domain.domain.WebCmsDomain;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import java.util.Optional;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCache;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.stereotype.Component;

@Component
public class WebCmsUrlCache {
    private static final Cache DEFAULT_CACHE = new NoOpCache("WebCmsUrlCache");
    private final CacheManager cacheManager;
    private final WebCmsUrlRepository urlRepository;
    private Cache cache = DEFAULT_CACHE;

    public Optional<WebCmsUrl> getUrlForPathAndDomain(String path, WebCmsDomain domain) {
        String cacheKey = this.cacheKey(path, domain);
        Cache.ValueWrapper urlId = this.cache.get((Object)cacheKey);
        if (urlId == null) {
            WebCmsUrl url = this.urlRepository.findOneByPathAndEndpoint_Domain(path, domain).orElse(null);
            Optional<WebCmsUrl> value = Optional.ofNullable(url);
            this.cache.put((Object)cacheKey, value.map(WebCmsUrl::getId).orElse(null));
            return value;
        }
        Long actualId = (Long)urlId.get();
        return actualId != null ? this.urlRepository.findById(actualId) : Optional.empty();
    }

    public void remove(WebCmsUrl url) {
        this.cache.evict((Object)this.cacheKey(url.getPath(), url.getEndpoint().getDomain()));
    }

    private String cacheKey(String path, WebCmsDomain domain) {
        return (domain != null ? domain.getId() + ":" : "no-domain:") + path;
    }

    @PostRefresh
    public void reloadCache() {
        Cache candidate = this.cacheManager.getCache("WebCmsUrlCache");
        this.cache = candidate != null ? new TransactionAwareCacheDecorator(candidate) : DEFAULT_CACHE;
    }

    public WebCmsUrlCache(CacheManager cacheManager, WebCmsUrlRepository urlRepository) {
        this.cacheManager = cacheManager;
        this.urlRepository = urlRepository;
    }
}

