/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url;

import com.foreach.across.modules.hibernate.aop.EntityInterceptorAdapter;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointRepository;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrlCache;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
class WebCmsUrlInterceptor
extends EntityInterceptorAdapter<WebCmsUrl> {
    private final WebCmsUrlRepository urlRepository;
    private final WebCmsUrlCache urlCache;
    private final WebCmsEndpointRepository endpointRepository;

    public boolean handles(Class<?> entityClass) {
        return WebCmsUrl.class.isAssignableFrom(entityClass);
    }

    public void beforeCreate(WebCmsUrl entity) {
        this.urlCache.remove(entity);
    }

    public void beforeUpdate(WebCmsUrl updatedUrl) {
        WebCmsUrl current = this.urlRepository.findById(updatedUrl.getId()).orElse(null);
        if (current != null && !StringUtils.equals((CharSequence)current.getPath(), (CharSequence)updatedUrl.getPath())) {
            this.urlCache.remove(current);
        }
        this.urlCache.remove(updatedUrl);
    }

    public void beforeDelete(WebCmsUrl entity) {
        this.urlCache.remove(entity);
    }

    public void afterDelete(WebCmsUrl entity) {
        this.endpointRepository.refresh(entity.getEndpoint());
    }

    public void afterCreate(WebCmsUrl entity) {
        this.endpointRepository.refresh(entity.getEndpoint());
    }

    public void afterUpdate(WebCmsUrl entity) {
        this.endpointRepository.refresh(entity.getEndpoint());
    }

    public WebCmsUrlInterceptor(WebCmsUrlRepository urlRepository, WebCmsUrlCache urlCache, WebCmsEndpointRepository endpointRepository) {
        this.urlRepository = urlRepository;
        this.urlCache = urlCache;
        this.endpointRepository = endpointRepository;
    }
}

