/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url;

import com.foreach.across.modules.webcms.data.AbstractWebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.endpoint.support.EndpointModificationType;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import com.foreach.across.modules.webcms.infrastructure.ModificationReport;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class WebCmsUrlOnAssetImporter
extends AbstractWebCmsPropertyDataImporter<WebCmsAsset, WebCmsUrl> {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsUrlOnAssetImporter.class);
    static final String PROPERTY_NAME = "wcm:urls";
    private final WebCmsUrlRepository urlRepository;
    private final WebCmsAssetEndpointRepository assetEndpointRepository;
    private final WebCmsMultiDomainService multiDomainService;
    private final WebCmsEndpointService endpointService;

    @Override
    public boolean supports(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return WebCmsPropertyDataImporter.Phase.AFTER_ASSET_SAVED.equals((Object)phase) && PROPERTY_NAME.equals(dataEntry.getParentKey()) && asset instanceof WebCmsAsset;
    }

    @Override
    protected WebCmsUrl getExisting(WebCmsDataEntry data, WebCmsAsset parent) {
        String path = data.getMapData().containsKey("path") ? (String)data.getMapData().get("path") : data.getKey();
        WebCmsAssetEndpoint endpoint = this.assetEndpointRepository.findOneByAssetAndDomain(parent, this.multiDomainService.getCurrentDomainForEntity(parent)).orElse(null);
        if (endpoint != null) {
            return endpoint.getUrlWithPath(path).orElse(null);
        }
        return null;
    }

    @Override
    protected WebCmsUrl createDto(WebCmsDataEntry data, WebCmsUrl existing, WebCmsDataAction action, WebCmsAsset asset) {
        WebCmsEndpoint endpoint = this.assetEndpointRepository.findOneByAssetAndDomain(asset, this.multiDomainService.getCurrentDomainForEntity(asset)).orElse(null);
        if (existing != null) {
            if (action == WebCmsDataAction.REPLACE) {
                WebCmsUrl url = this.createNewWebCmsUrlDto(data, asset, endpoint);
                if (url != null) {
                    url.setId(existing.getId());
                }
                return url;
            }
            return (WebCmsUrl)existing.toDto();
        }
        return this.createNewWebCmsUrlDto(data, asset, endpoint);
    }

    private WebCmsUrl createNewWebCmsUrlDto(WebCmsDataEntry data, WebCmsAsset asset, WebCmsEndpoint endpointToUse) {
        WebCmsEndpoint endpoint;
        WebCmsEndpoint webCmsEndpoint = endpoint = endpointToUse != null ? endpointToUse : (WebCmsEndpoint)this.assetEndpointRepository.findOneByAssetAndDomain(asset, asset.getDomain()).orElse(null);
        if (endpoint != null) {
            Map<String, Object> dataValues = data.getMapData();
            String path = dataValues.containsKey("path") ? (String)dataValues.get("path") : data.getKey();
            Object rawStatus = data.isSingleValue() ? data.getSingleValue() : dataValues.get("httpStatus");
            HttpStatus httpStatus = rawStatus != null ? HttpStatus.valueOf((int)((Integer)rawStatus)) : null;
            return WebCmsUrl.builder().path(path).httpStatus(httpStatus).endpoint(endpoint).build();
        }
        LOG.warn("Unable to create url as no endpoint available for asset {} - data: {}", (Object)asset.getObjectId(), (Object)data);
        return null;
    }

    @Override
    protected void save(WebCmsUrl dto, WebCmsAsset parent) {
        if (dto.isPrimary()) {
            ModificationReport<EndpointModificationType, WebCmsUrl> modificationReport = this.endpointService.updateOrCreatePrimaryUrlForAsset(dto.getPath(), parent, false);
            switch (modificationReport.getModificationStatus()) {
                case SUCCESSFUL: {
                    if (!dto.isPrimaryLocked()) break;
                    WebCmsUrl primaryUrl = (WebCmsUrl)modificationReport.getNewValue().toDto();
                    primaryUrl.setPrimaryLocked(true);
                    this.urlRepository.save((Object)primaryUrl);
                    break;
                }
                case FAILED: {
                    LOG.error("Unable to change primary url for asset {} to {}", (Object)parent, (Object)dto.getPath());
                }
            }
        } else {
            this.urlRepository.save((Object)dto);
        }
    }

    @Override
    protected void delete(WebCmsUrl dto, WebCmsAsset parent) {
        this.urlRepository.delete((Object)dto);
    }

    @Override
    protected boolean applyDataValues(Map<String, Object> values, WebCmsUrl dto) {
        HashMap<String, Object> filtered = new HashMap<String, Object>(values);
        filtered.remove("httpStatus");
        boolean modified = super.applyDataValues(filtered, dto);
        if (dto.isPrimary()) {
            if (!values.containsKey("httpStatus") && !HttpStatus.OK.equals((Object)dto.getHttpStatus())) {
                dto.setHttpStatus(HttpStatus.OK);
                modified = true;
            }
            if (!values.containsKey("primaryLocked") && !dto.isPrimaryLocked()) {
                dto.setPrimaryLocked(true);
                modified = true;
            }
        }
        return modified;
    }

    public WebCmsUrlOnAssetImporter(WebCmsUrlRepository urlRepository, WebCmsAssetEndpointRepository assetEndpointRepository, WebCmsMultiDomainService multiDomainService, WebCmsEndpointService endpointService) {
        this.urlRepository = urlRepository;
        this.assetEndpointRepository = assetEndpointRepository;
        this.multiDomainService = multiDomainService;
        this.endpointService = endpointService;
    }
}

