/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url;

import com.foreach.across.modules.webcms.data.AbstractWebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataEntry;
import com.foreach.across.modules.webcms.data.WebCmsPropertyDataImporter;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpoint;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class WebCmsUrlOnEndpointImporter
extends AbstractWebCmsPropertyDataImporter<WebCmsEndpoint, WebCmsUrl> {
    private static final String PROPERTY_NAME = "wcm:urls";
    private final WebCmsUrlRepository urlRepository;

    @Override
    public boolean supports(WebCmsPropertyDataImporter.Phase phase, WebCmsDataEntry dataEntry, Object asset, WebCmsDataAction action) {
        return WebCmsPropertyDataImporter.Phase.AFTER_ASSET_SAVED.equals((Object)phase) && PROPERTY_NAME.equals(dataEntry.getParentKey()) && asset instanceof WebCmsEndpoint;
    }

    @Override
    protected WebCmsUrl getExisting(WebCmsDataEntry data, WebCmsEndpoint parent) {
        String path = data.getMapData().containsKey("path") ? (String)data.getMapData().get("path") : data.getKey();
        return parent.getUrlWithPath(path).orElse(null);
    }

    @Override
    protected WebCmsUrl createDto(WebCmsDataEntry data, WebCmsUrl existing, WebCmsDataAction action, WebCmsEndpoint parent) {
        if (existing != null) {
            if (action == WebCmsDataAction.REPLACE) {
                WebCmsUrl url = this.createNewWebCmsUrlDto(data, parent);
                if (url != null) {
                    url.setId(existing.getId());
                }
                return url;
            }
            return (WebCmsUrl)existing.toDto();
        }
        return this.createNewWebCmsUrlDto(data, parent);
    }

    private WebCmsUrl createNewWebCmsUrlDto(WebCmsDataEntry data, WebCmsEndpoint endpoint) {
        Object rawStatus;
        String path = data.getMapData().containsKey("path") ? (String)data.getMapData().get("path") : data.getKey();
        Object object = rawStatus = data.isSingleValue() ? data.getSingleValue() : data.getMapData().get("httpStatus");
        if (rawStatus == null) {
            throw new IllegalArgumentException("A valid HTTP status is required for importing urls");
        }
        HttpStatus httpStatus = HttpStatus.valueOf((int)((Integer)rawStatus));
        return WebCmsUrl.builder().path(path).httpStatus(httpStatus).endpoint(endpoint).build();
    }

    @Override
    protected void save(WebCmsUrl dto, WebCmsEndpoint parent) {
        this.urlRepository.save((Object)dto);
    }

    @Override
    protected void delete(WebCmsUrl dto, WebCmsEndpoint parent) {
        this.urlRepository.delete((Object)dto);
    }

    @Override
    protected boolean applyDataValues(Map<String, Object> values, WebCmsUrl dto) {
        HashMap<String, Object> filtered = new HashMap<String, Object>(values);
        filtered.remove("httpStatus");
        return super.applyDataValues(filtered, dto);
    }

    public WebCmsUrlOnEndpointImporter(WebCmsUrlRepository urlRepository) {
        this.urlRepository = urlRepository;
    }
}

