/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url.config;

import com.foreach.across.core.annotations.Exposed;
import com.foreach.across.modules.entity.config.EntityConfigurer;
import com.foreach.across.modules.entity.query.AssociatedEntityQueryExecutor;
import com.foreach.across.modules.entity.query.EntityQuery;
import com.foreach.across.modules.entity.registry.EntityAssociation;
import com.foreach.across.modules.entity.registry.EntityFactory;
import com.foreach.across.modules.entity.views.EntityViewProcessor;
import com.foreach.across.modules.entity.views.processors.DefaultValidationViewProcessor;
import com.foreach.across.modules.entity.views.processors.PropertyRenderingViewProcessor;
import com.foreach.across.modules.entity.views.processors.SaveEntityViewProcessor;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.asset.QWebCmsAssetEndpoint;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAssetEndpointRepository;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainAdminUiService;
import com.foreach.across.modules.webcms.domain.domain.WebCmsMultiDomainService;
import com.foreach.across.modules.webcms.domain.url.QWebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import com.foreach.across.modules.webcms.domain.url.web.WebCmsAssetPrimaryUrlFailedFormProcessor;
import com.foreach.across.modules.webcms.domain.url.web.WebCmsAssetPrimaryUrlFailureDetectionProcessor;
import com.foreach.across.modules.webcms.domain.url.web.WebCmsAssetUrlFormProcessor;
import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.ClassUtils;

@Exposed
@Configuration
public class WebCmsAssetUrlConfiguration {
    private final Set<Class<?>> assetTypes = new HashSet();

    public void enable(Class<? extends WebCmsAsset> assetType) {
        this.assetTypes.add(assetType);
    }

    public void disable(Class<? extends WebCmsAsset> assetType) {
        this.assetTypes.remove(assetType);
    }

    public boolean isEnabledForAsset(WebCmsAsset asset) {
        return asset != null && this.assetTypes.contains(ClassUtils.getUserClass((Object)asset));
    }

    @ConditionalOnAdminUI
    @Bean
    EntityConfigurer webCmsAssetUrlAssociationConfigurer(EntityFactory<WebCmsUrl> webCmsUrlEntityFactory, AssociatedEntityQueryExecutor<WebCmsUrl> webCmsUrlExecutorForPage, WebCmsAssetUrlFormProcessor urlFormProcessor, WebCmsAssetPrimaryUrlFailureDetectionProcessor primaryUrlFailureDetectionProcessor, WebCmsAssetPrimaryUrlFailedFormProcessor primaryUrlFormProcessor) {
        return entities -> entities.matching(config -> WebCmsAsset.class.isAssignableFrom(config.getEntityType()) && this.assetTypes.contains(config.getEntityType())).association(ab -> ab.name("urls").targetEntityType(WebCmsUrl.class).targetProperty("endpoint").associationType(EntityAssociation.Type.EMBEDDED).parentDeleteMode(EntityAssociation.ParentDeleteMode.WARN).listView(fvb -> fvb.showProperties(new String[]{".", "~endpoint"})).createFormView(fvb -> fvb.showProperties(new String[]{".", "~endpoint"}).viewProcessor((EntityViewProcessor)urlFormProcessor)).updateFormView(fvb -> fvb.showProperties(new String[]{".", "~endpoint"}).viewProcessor((EntityViewProcessor)urlFormProcessor)).deleteFormView().attribute(EntityFactory.class, (Object)webCmsUrlEntityFactory).show()).createOrUpdateFormView(fvb -> fvb.viewProcessor(WebCmsAssetPrimaryUrlFailureDetectionProcessor.class.getName(), (EntityViewProcessor)primaryUrlFailureDetectionProcessor, Integer.MAX_VALUE)).formView("primaryUrlFailed", fvb -> fvb.postProcess((factory, registry) -> {
            registry.remove(PropertyRenderingViewProcessor.class.getName());
            registry.remove(SaveEntityViewProcessor.class.getName());
            registry.remove(DefaultValidationViewProcessor.class.getName());
        }).viewProcessor((EntityViewProcessor)primaryUrlFormProcessor).messagePrefix(new String[]{"forms.primaryUrlFailed"})).postProcessor(cfg -> cfg.association("urls").setAttribute(AssociatedEntityQueryExecutor.class, (Object)webCmsUrlExecutorForPage));
    }

    @ConditionalOnAdminUI
    @Bean
    EntityFactory<WebCmsUrl> webCmsUrlEntityFactory(final WebCmsAssetEndpointRepository endpointRepository, final WebCmsMultiDomainService multiDomainService) {
        return new EntityFactory<WebCmsUrl>(){

            public WebCmsUrl createNew(Object ... args) {
                WebCmsUrl url = new WebCmsUrl();
                if (args[0] instanceof WebCmsAsset) {
                    WebCmsAsset asset = (WebCmsAsset)args[0];
                    url.setEndpoint(endpointRepository.findOneByAssetAndDomain(asset, multiDomainService.getCurrentDomainForEntity(asset)).orElse(null));
                }
                return url;
            }

            public WebCmsUrl createDto(WebCmsUrl entity) {
                return (WebCmsUrl)entity.toDto();
            }
        };
    }

    @ConditionalOnAdminUI
    @Bean
    AssociatedEntityQueryExecutor<WebCmsUrl> webCmsUrlExecutorForPage(final WebCmsAssetEndpointRepository pageEndpointRepository, final WebCmsUrlRepository urlRepository, final WebCmsMultiDomainAdminUiService multiDomainAdminUiService) {
        return new AssociatedEntityQueryExecutor<WebCmsUrl>(null, null){

            public List<WebCmsUrl> findAll(Object parent, EntityQuery query) {
                QWebCmsAssetEndpoint q = QWebCmsAssetEndpoint.webCmsAssetEndpoint;
                Iterable endpoints = pageEndpointRepository.findAll(multiDomainAdminUiService.applyVisibleDomainsPredicate((Predicate)q.asset.eq((WebCmsAsset)parent), q.domain));
                return urlRepository.findAll((Predicate)QWebCmsUrl.webCmsUrl.endpoint.in((Collection)endpoints));
            }

            public Page<WebCmsUrl> findAll(Object parent, EntityQuery query, Pageable pageable) {
                QWebCmsAssetEndpoint q = QWebCmsAssetEndpoint.webCmsAssetEndpoint;
                Iterable endpoints = pageEndpointRepository.findAll(multiDomainAdminUiService.applyVisibleDomainsPredicate((Predicate)q.asset.eq((WebCmsAsset)parent), q.domain));
                return urlRepository.findAll((Predicate)QWebCmsUrl.webCmsUrl.endpoint.in((Collection)endpoints), pageable);
            }
        };
    }
}

