/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url.validators;

import com.foreach.across.modules.entity.validators.EntityValidatorSupport;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;

@Component
public class WebCmsUrlValidator
extends EntityValidatorSupport<WebCmsUrl> {
    private final WebCmsUrlRepository urlRepository;

    public boolean supports(Class<?> clazz) {
        return WebCmsUrl.class.isAssignableFrom(clazz);
    }

    protected void postValidation(WebCmsUrl entity, Errors errors, Object ... validationHints) {
        if (!errors.hasFieldErrors("path")) {
            this.urlRepository.findOneByPathAndEndpoint_Domain(entity.getPath(), entity.getEndpoint().getDomain()).filter(existing -> !entity.equals(existing)).ifPresent(e -> errors.rejectValue("path", "alreadyExists"));
        }
        if (!errors.hasErrors() && entity.isPrimary()) {
            if (HttpStatus.Series.valueOf((HttpStatus)entity.getHttpStatus()) == HttpStatus.Series.REDIRECTION) {
                errors.rejectValue("httpStatus", "primaryUrlCannotBeRedirect", new Object[0], "Primary URL may not have a redirection HttpStatus.");
            }
            this.urlRepository.findAllByEndpoint(entity.getEndpoint()).stream().filter(url -> !url.equals((Object)entity) && url.isPrimary()).findFirst().ifPresent(existingPrimary -> errors.rejectValue("primary", "onlyOnePrimaryUrlPerEndpoint", new Object[]{existingPrimary.getPath()}, "Another primary URL exists."));
        }
    }

    public WebCmsUrlValidator(WebCmsUrlRepository urlRepository) {
        this.urlRepository = urlRepository;
    }
}

