/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url.web;

import com.foreach.across.modules.bootstrapui.elements.Style;
import com.foreach.across.modules.bootstrapui.ui.factories.BootstrapViewElements;
import com.foreach.across.modules.entity.support.EntityMessageCodeResolver;
import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.processors.support.EntityViewPageHelper;
import com.foreach.across.modules.entity.views.processors.support.ViewElementBuilderMap;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.web.ui.ViewElementBuilder;
import com.foreach.across.modules.web.ui.ViewElementBuilderContext;
import com.foreach.across.modules.web.ui.elements.ContainerViewElement;
import com.foreach.across.modules.web.ui.elements.HtmlViewElements;
import com.foreach.across.modules.web.ui.elements.builder.ContainerViewElementBuilder;
import com.foreach.across.modules.web.ui.elements.builder.ContainerViewElementBuilderSupport;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.endpoint.WebCmsEndpointService;
import com.foreach.across.modules.webcms.domain.endpoint.support.EndpointModificationType;
import com.foreach.across.modules.webcms.domain.url.WebCmsUrl;
import com.foreach.across.modules.webcms.domain.url.repositories.WebCmsUrlRepository;
import com.foreach.across.modules.webcms.infrastructure.ModificationReport;
import com.foreach.across.modules.webcms.infrastructure.ModificationStatus;
import java.util.Collections;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;

@ConditionalOnAdminUI
@Component
public class WebCmsAssetPrimaryUrlFailedFormProcessor
extends EntityViewProcessorAdapter {
    private final WebCmsEndpointService endpointService;
    private final EntityViewPageHelper pageHelper;
    private final WebCmsUrlRepository urlRepository;

    public void initializeCommandObject(EntityViewRequest entityViewRequest, EntityViewCommand command, WebDataBinder dataBinder) {
        WebCmsAsset asset = (WebCmsAsset)entityViewRequest.getEntityViewContext().getEntity(WebCmsAsset.class);
        Optional<WebCmsUrl> primaryUrl = this.endpointService.getPrimaryUrlForAsset(asset);
        PrimaryUrlUpdateFormData data = new PrimaryUrlUpdateFormData();
        data.setNewPrimaryUrl(entityViewRequest.getWebRequest().getParameter("requestedUrl"));
        data.setCurrentPrimaryUrl(primaryUrl.orElse(null));
        data.setAction(primaryUrl.isPresent() ? PrimaryUrlUpdateAction.LOCK_CURRENT_PRIMARY_URL : PrimaryUrlUpdateAction.CREATE_NEW_PRIMARY_URL);
        command.setEntity((Object)data);
    }

    protected void preProcess(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command) {
        PrimaryUrlUpdateFormData data = (PrimaryUrlUpdateFormData)command.getEntity(PrimaryUrlUpdateFormData.class);
        if (data.getCurrentPrimaryUrl() != null && data.getCurrentPrimaryUrl().isPrimaryLocked()) {
            entityView.setRedirectUrl(entityViewRequest.getEntityViewContext().getLinkBuilder().forInstance(entityViewRequest.getEntityViewContext().getEntity()).updateView().toUriString());
        }
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        PrimaryUrlUpdateFormData data = (PrimaryUrlUpdateFormData)command.getEntity(PrimaryUrlUpdateFormData.class);
        WebCmsAsset asset = (WebCmsAsset)entityViewRequest.getEntityViewContext().getEntity(WebCmsAsset.class);
        boolean actionCompleted = true;
        if (data.getAction() == PrimaryUrlUpdateAction.LOCK_CURRENT_PRIMARY_URL) {
            actionCompleted = this.lockCurrentPrimaryUrl(entityViewRequest, asset);
        } else if (data.getAction() == PrimaryUrlUpdateAction.CREATE_NEW_PRIMARY_URL) {
            actionCompleted = this.createNewPrimaryUrl(entityViewRequest, asset, data.getNewPrimaryUrl());
        }
        if (actionCompleted) {
            entityView.setRedirectUrl(entityViewRequest.getEntityViewContext().getLinkBuilder().forInstance((Object)asset).updateView().toUriString());
        }
    }

    private boolean createNewPrimaryUrl(EntityViewRequest entityViewRequest, WebCmsAsset<?> asset, String newPrimaryUrl) {
        BindingResult errors = entityViewRequest.getBindingResult();
        if (StringUtils.isBlank((CharSequence)newPrimaryUrl)) {
            errors.rejectValue("entity.newPrimaryUrl", "NotBlank");
        } else {
            ModificationReport<EndpointModificationType, WebCmsUrl> modificationReport = this.endpointService.updateOrCreatePrimaryUrlForAsset(newPrimaryUrl, asset, false);
            if (modificationReport.getModificationStatus() == ModificationStatus.FAILED) {
                errors.rejectValue("entity.newPrimaryUrl", "alreadyExists");
            } else {
                WebCmsUrl primaryUrl = (WebCmsUrl)modificationReport.getNewValue().toDto();
                primaryUrl.setPrimaryLocked(true);
                this.urlRepository.save((Object)primaryUrl);
                this.pageHelper.addGlobalFeedbackAfterRedirect(entityViewRequest, Style.SUCCESS, "forms.primaryUrlFailed.feedback.primaryUrlCreated");
            }
        }
        return !errors.hasErrors();
    }

    private boolean lockCurrentPrimaryUrl(EntityViewRequest entityViewRequest, WebCmsAsset<?> asset) {
        this.endpointService.getPrimaryUrlForAsset(asset).ifPresent(url -> {
            WebCmsUrl dto = (WebCmsUrl)url.toDto();
            dto.setPrimaryLocked(true);
            this.urlRepository.save((Object)dto);
            this.pageHelper.addGlobalFeedbackAfterRedirect(entityViewRequest, Style.SUCCESS, "forms.primaryUrlFailed.feedback.primaryUrlLocked");
        });
        return true;
    }

    protected void render(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElementBuilderSupport<?, ?> containerBuilder, ViewElementBuilderMap builderMap, ViewElementBuilderContext builderContext) {
        PrimaryUrlUpdateFormData data = (PrimaryUrlUpdateFormData)entityViewRequest.getCommand().getEntity(PrimaryUrlUpdateFormData.class);
        EntityMessageCodeResolver codeResolver = entityViewRequest.getEntityViewContext().getMessageCodeResolver();
        ContainerViewElementBuilder form = HtmlViewElements.html.builders.container();
        form.add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.alert().warning().add(new ViewElementBuilder[]{HtmlViewElements.html.builders.unescapedText(codeResolver.getMessageWithFallback("description", null))})});
        if (data.getCurrentPrimaryUrl() != null) {
            form.add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.formGroup().control((ViewElementBuilder)BootstrapViewElements.bootstrap.builders.radio().controlName("entity.action").value((Object)PrimaryUrlUpdateAction.LOCK_CURRENT_PRIMARY_URL.name()).selected(data.getAction() == PrimaryUrlUpdateAction.LOCK_CURRENT_PRIMARY_URL).label(codeResolver.getMessageWithFallback("action.lockPrimaryUrl", new Object[]{data.getCurrentPrimaryUrlValue()}, null))).helpBlock(codeResolver.getMessageWithFallback("action.lockPrimaryUrl[description]", null))});
        }
        form.add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.radio().controlName("entity.action").value((Object)PrimaryUrlUpdateAction.CREATE_NEW_PRIMARY_URL.name()).selected(data.getAction() == PrimaryUrlUpdateAction.CREATE_NEW_PRIMARY_URL).label(codeResolver.getMessageWithFallback("action.createPrimaryUrl", null))});
        form.add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.formGroup().control((ViewElementBuilder)BootstrapViewElements.bootstrap.builders.textbox().controlName("entity.newPrimaryUrl").placeholder(codeResolver.getMessageWithFallback("action.createPrimaryUrl[placeholder]", null)).text(data.getNewPrimaryUrl()).attribute("data-dependson", Collections.singletonMap("[name='entity.action']", Collections.singletonMap("values", Collections.singleton(PrimaryUrlUpdateAction.CREATE_NEW_PRIMARY_URL.name()))))).descriptionBlock(codeResolver.getMessageWithFallback("action.createPrimaryUrl[description]", null))});
        form.add(new ViewElementBuilder[]{BootstrapViewElements.bootstrap.builders.formGroup().control((ViewElementBuilder)BootstrapViewElements.bootstrap.builders.radio().controlName("entity.action").value((Object)PrimaryUrlUpdateAction.DO_NOTHING.name()).selected(data.getAction() == PrimaryUrlUpdateAction.DO_NOTHING).label(codeResolver.getMessageWithFallback("action.doNothing", null))).helpBlock(codeResolver.getMessageWithFallback("action.doNothing[help]", null))});
        ((ContainerViewElementBuilderSupport)builderMap.get("entityForm-column-0", ContainerViewElementBuilderSupport.class)).add(new ViewElementBuilder[]{form});
    }

    protected void postRender(EntityViewRequest entityViewRequest, EntityView entityView, ContainerViewElement container, ViewElementBuilderContext builderContext) {
        container.removeFromTree("btn-cancel");
    }

    public WebCmsAssetPrimaryUrlFailedFormProcessor(WebCmsEndpointService endpointService, EntityViewPageHelper pageHelper, WebCmsUrlRepository urlRepository) {
        this.endpointService = endpointService;
        this.pageHelper = pageHelper;
        this.urlRepository = urlRepository;
    }

    static class PrimaryUrlUpdateFormData {
        PrimaryUrlUpdateAction action = PrimaryUrlUpdateAction.LOCK_CURRENT_PRIMARY_URL;
        String newPrimaryUrl;
        WebCmsUrl currentPrimaryUrl;

        String getCurrentPrimaryUrlValue() {
            return this.currentPrimaryUrl != null ? this.currentPrimaryUrl.getPath() : null;
        }

        public PrimaryUrlUpdateAction getAction() {
            return this.action;
        }

        public String getNewPrimaryUrl() {
            return this.newPrimaryUrl;
        }

        public WebCmsUrl getCurrentPrimaryUrl() {
            return this.currentPrimaryUrl;
        }

        public void setAction(PrimaryUrlUpdateAction action) {
            this.action = action;
        }

        public void setNewPrimaryUrl(String newPrimaryUrl) {
            this.newPrimaryUrl = newPrimaryUrl;
        }

        public void setCurrentPrimaryUrl(WebCmsUrl currentPrimaryUrl) {
            this.currentPrimaryUrl = currentPrimaryUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrimaryUrlUpdateFormData)) {
                return false;
            }
            PrimaryUrlUpdateFormData other = (PrimaryUrlUpdateFormData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PrimaryUrlUpdateAction this$action = this.getAction();
            PrimaryUrlUpdateAction other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            String this$newPrimaryUrl = this.getNewPrimaryUrl();
            String other$newPrimaryUrl = other.getNewPrimaryUrl();
            if (this$newPrimaryUrl == null ? other$newPrimaryUrl != null : !this$newPrimaryUrl.equals(other$newPrimaryUrl)) {
                return false;
            }
            WebCmsUrl this$currentPrimaryUrl = this.getCurrentPrimaryUrl();
            WebCmsUrl other$currentPrimaryUrl = other.getCurrentPrimaryUrl();
            return !(this$currentPrimaryUrl == null ? other$currentPrimaryUrl != null : !((Object)((Object)this$currentPrimaryUrl)).equals((Object)other$currentPrimaryUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PrimaryUrlUpdateFormData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PrimaryUrlUpdateAction $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            String $newPrimaryUrl = this.getNewPrimaryUrl();
            result = result * 59 + ($newPrimaryUrl == null ? 43 : $newPrimaryUrl.hashCode());
            WebCmsUrl $currentPrimaryUrl = this.getCurrentPrimaryUrl();
            result = result * 59 + ($currentPrimaryUrl == null ? 43 : ((Object)((Object)$currentPrimaryUrl)).hashCode());
            return result;
        }

        public String toString() {
            return "WebCmsAssetPrimaryUrlFailedFormProcessor.PrimaryUrlUpdateFormData(action=" + (Object)((Object)this.getAction()) + ", newPrimaryUrl=" + this.getNewPrimaryUrl() + ", currentPrimaryUrl=" + (Object)((Object)this.getCurrentPrimaryUrl()) + ")";
        }
    }

    static enum PrimaryUrlUpdateAction {
        LOCK_CURRENT_PRIMARY_URL,
        CREATE_NEW_PRIMARY_URL,
        DO_NOTHING;

    }
}

