/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.domain.url.web;

import com.foreach.across.modules.entity.views.EntityView;
import com.foreach.across.modules.entity.views.processors.EntityViewProcessorAdapter;
import com.foreach.across.modules.entity.views.request.EntityViewCommand;
import com.foreach.across.modules.entity.views.request.EntityViewRequest;
import com.foreach.across.modules.entity.web.links.SingleEntityViewLinkBuilder;
import com.foreach.across.modules.webcms.config.ConditionalOnAdminUI;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.endpoint.support.PrimaryUrlForAssetFailedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@ConditionalOnAdminUI
@Component
public final class WebCmsAssetPrimaryUrlFailureDetectionProcessor
extends EntityViewProcessorAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(WebCmsAssetPrimaryUrlFailureDetectionProcessor.class);

    @EventListener
    void detectPrimaryUrlUpdateFailure(PrimaryUrlForAssetFailedEvent event) {
        WebCmsAsset assetToListenFor;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null && (assetToListenFor = (WebCmsAsset)requestAttributes.getAttribute(((Object)((Object)this)).getClass().getName(), 0)) != null && assetToListenFor == event.getAsset()) {
            LOG.trace("Received PrimaryUrlForAssetFailedEvent for asset being updated");
            requestAttributes.setAttribute(((Object)((Object)this)).getClass().getName() + ".failureEvent", (Object)event, 0);
        }
    }

    protected void preProcess(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command) {
        WebCmsAsset asset = (WebCmsAsset)entityViewRequest.getCommand().getEntity(WebCmsAsset.class);
        RequestContextHolder.currentRequestAttributes().setAttribute(((Object)((Object)this)).getClass().getName(), (Object)asset, 0);
    }

    public void postProcess(EntityViewRequest entityViewRequest, EntityView entityView) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        requestAttributes.removeAttribute(((Object)((Object)this)).getClass().getName(), 0);
        requestAttributes.removeAttribute(((Object)((Object)this)).getClass().getName() + ".failureEvent", 0);
    }

    protected void doPost(EntityViewRequest entityViewRequest, EntityView entityView, EntityViewCommand command, BindingResult bindingResult) {
        PrimaryUrlForAssetFailedEvent event;
        if (!bindingResult.hasErrors() && entityView.isRedirect() && (event = (PrimaryUrlForAssetFailedEvent)RequestContextHolder.currentRequestAttributes().getAttribute(((Object)((Object)this)).getClass().getName() + ".failureEvent", 0)) != null && event.isFailed()) {
            LOG.warn("Redirecting to primary URL failed form - automatic update of primary url for {} has failed", command.getEntity());
            String requestedUrl = event.getModificationReport().hasNewValue() ? event.getModificationReport().getNewValue().getPath() : null;
            entityView.setRedirectUrl(((SingleEntityViewLinkBuilder)((SingleEntityViewLinkBuilder)entityViewRequest.getEntityViewContext().getLinkBuilder().forInstance(command.getEntity()).updateView().withViewName("primaryUrlFailed")).withQueryParam("requestedUrl", new Object[]{requestedUrl})).toUriString());
        }
    }
}

