/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.infrastructure;

import java.util.Locale;
import java.util.stream.Collectors;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public final class ValidationFailedException
extends RuntimeException {
    private final String errorsList;

    public ValidationFailedException(String message, Errors errors) {
        this(null, message, errors);
    }

    public ValidationFailedException(MessageSource messageSource, String message, Errors errors) {
        super(message);
        this.errorsList = "[" + errors.getErrorCount() + "] validation errors: " + System.lineSeparator() + "   " + errors.getAllErrors().stream().map(e -> this.errorToString((ObjectError)e, messageSource)).collect(Collectors.joining(System.lineSeparator() + "   "));
    }

    @Override
    public String getMessage() {
        return super.getMessage() + ", " + this.errorsList;
    }

    private String errorToString(ObjectError error, MessageSource messageSource) {
        if (error instanceof FieldError) {
            FieldError fe = (FieldError)error;
            return "Field error in object '" + fe.getObjectName() + "' on field '" + fe.getField() + "': rejected value [" + fe.getRejectedValue() + "]; " + (messageSource != null ? messageSource.getMessage((MessageSourceResolvable)fe, Locale.US) : fe.getDefaultMessage());
        }
        return "Error in object '" + error.getObjectName() + "': " + (messageSource != null ? messageSource.getMessage((MessageSourceResolvable)error, Locale.US) : error.getDefaultMessage());
    }
}

