/*
 * Decompiled with CFR 0.152.
 */
package com.foreach.across.modules.webcms.infrastructure;

import com.foreach.across.modules.webcms.data.WebCmsDataAction;
import com.foreach.across.modules.webcms.data.WebCmsDataImportAction;
import com.foreach.across.modules.webcms.domain.asset.WebCmsAsset;
import com.foreach.across.modules.webcms.domain.page.WebCmsPage;
import java.text.Normalizer;
import java.util.Date;
import java.util.UUID;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class WebCmsUtils {
    private WebCmsUtils() {
    }

    public static boolean isPublishedOnDate(@NonNull WebCmsAsset asset, @NonNull Date date) {
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return asset.isPublished() && (asset.getPublicationDate() == null || asset.getPublicationDate().before(date));
    }

    public static String generateObjectId(@NonNull String collectionId) {
        if (collectionId == null) {
            throw new NullPointerException("collectionId is marked non-null but is null");
        }
        return WebCmsUtils.prefixObjectIdForCollection(UUID.randomUUID().toString(), collectionId);
    }

    public static String prefixObjectIdForCollection(@NonNull String objectId, @NonNull String collectionId) {
        if (objectId == null) {
            throw new NullPointerException("objectId is marked non-null but is null");
        }
        if (collectionId == null) {
            throw new NullPointerException("collectionId is marked non-null but is null");
        }
        return StringUtils.startsWith((CharSequence)objectId, (CharSequence)(collectionId + ":")) ? objectId : collectionId + ":" + objectId;
    }

    public static boolean isObjectIdForCollection(String objectId, @NonNull String collectionId) {
        if (collectionId == null) {
            throw new NullPointerException("collectionId is marked non-null but is null");
        }
        return StringUtils.startsWith((CharSequence)objectId, (CharSequence)(collectionId + ":"));
    }

    public static String generateUrlPathSegment(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return StringUtils.removeStart((String)StringUtils.removeEnd((String)Normalizer.normalize(StringUtils.lowerCase((String)text), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").replaceAll("[^\\p{Alnum}]+", "-"), (String)"-"), (String)"-");
    }

    public static String generateCanonicalPath(@NonNull WebCmsPage page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        WebCmsPage parent = page.getParent();
        if (parent != null) {
            return StringUtils.removeEnd((String)parent.getCanonicalPath(), (String)"/") + "/" + StringUtils.defaultString((String)page.getPathSegment());
        }
        return "/" + StringUtils.defaultString((String)page.getPathSegment());
    }

    public static String combineUrlSegments(@NonNull String baseUrl, @NonNull String path) {
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (StringUtils.contains((CharSequence)baseUrl, (int)42)) {
            return StringUtils.replace((String)baseUrl, (String)"*", (String)path);
        }
        return StringUtils.removeEnd((String)baseUrl, (String)"/") + "/" + path;
    }

    public static WebCmsDataAction convertImportActionToDataAction(Object existing, WebCmsDataImportAction requested) {
        if (existing != null) {
            if (requested == WebCmsDataImportAction.DELETE) {
                return WebCmsDataAction.DELETE;
            }
            if (requested == WebCmsDataImportAction.CREATE_OR_UPDATE || requested == WebCmsDataImportAction.UPDATE) {
                return WebCmsDataAction.UPDATE;
            }
            if (requested == WebCmsDataImportAction.CREATE_OR_REPLACE || requested == WebCmsDataImportAction.REPLACE) {
                return WebCmsDataAction.REPLACE;
            }
        } else if (requested == WebCmsDataImportAction.CREATE || requested == WebCmsDataImportAction.CREATE_OR_UPDATE || requested == WebCmsDataImportAction.CREATE_OR_REPLACE) {
            return WebCmsDataAction.CREATE;
        }
        return null;
    }
}

